;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: STREAM -*-
;;;
;;; **********************************************************************
;;; This code was written by Raymond Toy and has been placed in the public
;;; domain.
;;;
(ext:file-comment "$Header: src/pcl/simple-streams/external-formats/euc-kr.lisp $")

(in-package "STREAM")
(intl:textdomain "cmucl")

;; This table is generated from
;; ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/KSC/KSX1001.TXT
;;
;; However, for each code, #x2121 was subtracted and the table placed
;; in a 94x94 array.  After subtracting #x2121, the low 8 bits of the
;; result is the first index in the array and the high 8 bits are the
;; second index.  Also, for entries that are missing, we use the
;; Unicode character #xfffe, which is illegal in a string.
(defconstant +euc-kr+
  (make-array '(94 94) :element-type '(unsigned-byte 16)
   :initial-contents
   `((#x3000 #x21D2 #xFF01 #x3131 #x2170 #x2500 #x3395 #xC6 #xE6 #x3041
      #x30A1 #x410 #xFFFE #xFFFE #xFFFE #xAC00 #xAD0C #xAE79 #xB05D #xB1DF
      #xB367 #xB540 #xB798 #xB96B #xBB00 #xBC99 #xBE68 #xC0E5 #xC22F #xC434
      #xC5D0 #xC6E9 #xC810 #xC9D5 #xCC3C #xCE58 #xD044 #xD264 #xD408 #xD624
      #xFFFE #x4F3D #x5323 #x77BC #x68E8 #x79D1 #x5340 #x9B3C #x671E #x7D0D
      #x4E39 #x68F9 #x863F #x7149 #x907C #x7ACB #x8511 #x6C76 #x767C #x78A7
      #x5B5A #x813E #x5098 #x80E5 #x8056 #x620D #x5D69 #xF972 #x6AFB #xF983
      #xF9A6 #x70CF #x7A88 #x904B #x6FE1 #x8B70 #xF9F7 #x969C #x714E #x975C
      #x8E2A #x54AB #x93F6 #x8CAC #x6912 #x8D05 #x9438 #x962A #x54C1 #xFA08
      #x5F62 #x798D #x723B #xFFFE)
     (#x3001 #x21D4 #xFF02 #x3132 #x2171 #x2502 #x3396 #xD0 #x111 #x3042
      #x30A2 #x411 #xFFFE #xFFFE #xFFFE #xAC01 #xAD0D #xAE7B #xB07C #xB1E8
      #xB369 #xB541 #xB799 #xB96D #xBB04 #xBC9A #xBE6A #xC0E8 #xC231 #xC43C
      #xC5D1 #xC6EC #xC811 #xC9D6 #xCC3D #xCE59 #xD045 #xD280 #xD41D #xD62D
      #xFFFE #x4F73 #x5CAC #x9210 #x6EAA #x83D3 #x53E3 #xF907 #x671F #xF926
      #x4EB6 #x6AC2 #x87BA #x7489 #x9B27 #x7B20 #x51A5 #x7D0A #x8DCB #x8617
      #x5B75 #x81C2 #x522A #x8212 #x8072 #x624B #x745F #x6DF1 #x7F4C #x6B5F
      #x95BB #x71AC #x7AAF #x9695 #x7336 #x91AB #xF9F8 #x518D #x7420 #x9802
      #x8E35 #x5730 #x96C6 #x51C4 #x695A #x53D6 #x5451 #x516B #x7A1F #xFA09
      #x6CC2 #x79BE #x80B4 #xFFFE)
     (#x3002 #x2200 #xFF03 #x3133 #x2172 #x250C #x3397 #xAA #xF0 #x3043
      #x30A3 #x412 #xFFFE #xFFFE #xFFFE #xAC04 #xAD0F #xAE7C #xB07D #xB1E9
      #xB36B #xB543 #xB79C #xB974 #xBB0D #xBCA0 #xBE70 #xC0EC #xC232 #xC43D
      #xC5D4 #xC6F0 #xC813 #xC9D9 #xCC3E #xCE5C #xD047 #xD281 #xD440 #xD638
      #xFFFE #x5047 #x7532 #x9ED4 #x754C #x8A87 #x53E5 #x53EB #x675E #xF927
      #x4F46 #x6DD8 #x88F8 #x7DF4 #x9F8D #x7C92 #x540D #x7D0B #x91B1 #x95E2
      #x5BCC #x83F2 #x5C71 #x85AF #x8165 #x6388 #x819D #x700B #x9DAF #x6C5D
      #x9AE5 #x7352 #x7E47 #x96F2 #x7337 #x4E8C #xF9F9 #x54C9 #x7530 #x9F0E
      #x937E #x5740 #x5FB5 #x59BB #x6A35 #x5439 #x5606 #x53ED #x6953 #x9805
      #x6ECE #x82B1 #x9175 #xFFFE)
     (#xB7 #x2203 #xFF04 #x3134 #x2173 #x2510 #x2113 #x126 #x127 #x3044
      #x30A4 #x413 #xFFFE #xFFFE #xFFFE #xAC07 #xAD11 #xAE7D #xB080 #xB1EC
      #xB36E #xB544 #xB7A0 #xB975 #xBB0F #xBCA1 #xBE71 #xC0F4 #xC234 #xC448
      #xC5D8 #xC6F8 #xC815 #xC9DA #xCC44 #xCE5F #xD049 #xD284 #xD444 #xD639
      #xFFFE #x50F9 #x80DB #x52AB #x7678 #x8AB2 #x548E #x572D #x68CB #x8872
      #x55AE #x6E21 #x908F #x806F #x58D8 #x6469 #x547D #x805E #x9262 #x9739
      #x5E9C #x871A #x6563 #x897F #x8AA0 #x641C #x8768 #x751A #x9E1A #xF984
      #x9E7D #x7B7D #x7E5E #x97FB #xF9CC #x4EE5 #x4ECD #x5728 #x7538 #x5236
      #x9418 #x5FD7 #x61F2 #x60BD #x7092 #x5634 #x5766 #x634C #x8AF7 #x4EA5
      #x7005 #x83EF #x9A4D #xFFFE)
     (#x2025 #xB4 #xFF05 #x3135 #x2174 #x2518 #x3398 #xFFFE #x131 #x3045
      #x30A5 #x414 #xFFFE #xFFFE #xFFFE #xAC08 #xAD18 #xAE84 #xB084 #xB1F0
      #xB370 #xB545 #xB7A8 #xB978 #xBB11 #xBCA4 #xBE73 #xC0F5 #xC248 #xC464
      #xC5E0 #xC6F9 #xC816 #xC9DC #xCC45 #xCE60 #xD050 #xD288 #xD45C #xD63C
      #xFFFE #x52A0 #x9240 #x602F #x78CE #x8DE8 #x5614 #x594E #x68C4 #x56CA
      #x5718 #x6ED4 #xF95C #x84EE #x5A41 #x746A #x660E #x868A #x9AEE #xF965
      #xF966 #x88E8 #x6C55 #x8A93 #x9192 #x6536 #x6FD5 #x82AF #x4E5F #x74B5
      #x66C4 #x8708 #x8000 #x851A #x745C #x4F0A #x5269 #x5BB0 #x7551 #x5291
      #x4F50 #x6301 #x6F84 #x8655 #x7126 #x5A36 #x5F48 #x4F69 #x8C4A #x5055
      #x7050 #x8A71 #x4FAF #xFFFE)
     (#x2026 #xFF5E #xFF06 #x3136 #x2175 #x2514 #x33C4 #x132 #x133 #x3046
      #x30A6 #x415 #xFFFE #xFFFE #xFFFE #xAC09 #xAD1C #xAE85 #xB08C #xB1F9
      #xB371 #xB54B #xB7A9 #xB97C #xBB18 #xBCA7 #xBE74 #xC0F7 #xC250 #xC465
      #xC5E1 #xC6FD #xC81C #xC9DD #xCC48 #xCE61 #xD054 #xD290 #xD460 #xD640
      #xFFFE #x53EF #x9598 #x8FF2 #x7A3D #x904E #x5775 #x63C6 #x6A5F #x5A18
      #x58C7 #x6FE4 #x6D1B #x8F26 #x5C62 #x75F2 #x669D #x9580 #x9B43 #x535E
      #x6276 #x8AB9 #x73CA #x901D #x4E16 #x6578 #x62FE #x8AF6 #x503B #x7916
      #xF9A7 #x8AA4 #x8170 #x9B31 #x7531 #xF9DD #x5B55 #x624D #x7672 #x557C
      #x5750 #x6307 #x4E14 #x501C #x785D #x5C31 #x619A #x5504 #x98A8 #x54B3
      #x70AF #x8B41 #x5019 #xFFFE)
     (#xA8 #x2C7 #xFF07 #x3137 #x2176 #x251C #x33A3 #xFFFE #x138 #x3047
      #x30A7 #x401 #xFFFE #xFFFE #xFFFE #xAC0A #xAD20 #xAE8C #xB08D #xB1FB
      #xB374 #xB54C #xB7AB #xB984 #xBB1C #xBCA8 #xBE75 #xC0F9 #xC251 #xC468
      #xC5E3 #xC704 #xC81D #xC9E0 #xCC4C #xCE68 #xD058 #xD291 #xD464 #xD645
      #xFFFE #x5475 #x525B #x5048 #x7CFB #x934B #x57A2 #x69FB #x6B3A #xF928
      #x5F56 #x71FE #x70D9 #x9023 #x6A13 #x78BC #x6927 #x96EF #x5023 #x5F01
      #x6577 #x8B6C #x7523 #x92E4 #x52E2 #x6A39 #x7FD2 #x4EC0 #x51B6 #xF985
      #x71C1 #x9C32 #xF9C2 #x4E90 #xF9CD #xF9DE #x82BF #x6750 #x7B4C #x5824
      #x5DE6 #x646F #x4F98 #xF9FF #x7901 #x708A #x6B4E #x6096 #x99AE #x5793
      #x7192 #x8CA8 #x539A #xFFFE)
     (#x3003 #x2D8 #xFF08 #x3138 #x2177 #x252C #x33A4 #x13F #x140 #x3048
      #x30A8 #x416 #xFFFE #xFFFE #xFFFE #xAC10 #xAD29 #xAEBC #xB08F #xB1FD
      #xB378 #xB54D #xB7AC #xB985 #xBB20 #xBCB0 #xBE7B #xC100 #xC254 #xC46C
      #xC5E5 #xC705 #xC820 #xC9E2 #xCC54 #xCE69 #xD060 #xD295 #xD46D #xD648
      #xFFFE #x54E5 #x5808 #x61A9 #x7E6B #x9846 #x5BC7 #x73EA #x6C23 #xF929
      #x65B7 #x76DC #x73DE #x934A #x6DDA #x78E8 #x6E9F #x52FF #x508D #x8B8A
      #x65A7 #x8CBB #x759D #x9ECD #x6B72 #x6B8A #x8936 #x5341 #x591C #x8207
      #x8449 #x9F07 #x87EF #x718A #x7652 #x5937 #x4ED4 #x683D #x7B8B #x5E1D
      #x5EA7 #x652F #x501F #x5254 #x790E #x7FE0 #x7058 #x6557 #x5F7C #x595A
      #x73E9 #x9774 #x540E #xFFFE)
     (#xAD #x2DD #xFF09 #x3139 #x2178 #x2524 #x33A5 #x141 #x142 #x3049
      #x30A9 #x417 #xFFFE #xFFFE #xFFFE #xAC11 #xAD2C #xAEBD #xB091 #xB204
      #xB380 #xB550 #xB7AD #xB987 #xBB29 #xBCB1 #xBE7C #xC104 #xC258 #xC474
      #xC5EC #xC708 #xC824 #xC9E4 #xCC55 #xCE6B #xD06C #xD29C #xD46F #xD649
      #xFFFE #x5609 #x59DC #x63ED #x7E7C #x5ED3 #x5D87 #x7845 #x6C7D #xF92A
      #x65E6 #x7779 #x7D61 #x51BD #x6F0F #x99AC #x76BF #x6C95 #x574A #x8FA8
      #x6D6E #x9119 #x7B97 #x9F20 #x6D17 #x6C34 #x8972 #xF973 #x60F9 #x8245
      #xF9A8 #x5C4B #x8981 #x96C4 #xF9CE #x59E8 #x523A #x6893 #x7BAD #x5F1F
      #x632B #x65E8 #x53C9 #x5C3A #x79D2 #x805A #x70AD #x6C9B #x62AB #x5B69
      #x7469 #xFA0B #x543C #xFFFE)
     (#x2015 #x2DA #xFF0A #x313A #x2179 #x2534 #x33A6 #xD8 #xF8 #x304A
      #x30AA #x418 #xFFFE #xFFFE #xFFFE #xAC12 #xAD2D #xAEBE #xB098 #xB205
      #xB381 #xB554 #xB7B4 #xB989 #xBB2B #xBCB3 #xBE7D #xC108 #xC260 #xC475
      #xC5ED #xC70C #xC82C #xC9E7 #xCC57 #xCE6D #xD06D #xD2A0 #xD478 #xD64B
      #xFFFE #x5AC1 #x5CA1 #x64CA #x8A08 #x69E8 #x5ED0 #x7ABA #x6C82 #xF92B
      #x6A80 #x79B1 #x843D #x5217 #x763B #x9B54 #x7791 #x7269 #x59A8 #x8FAF
      #x6EA5 #x975E #x849C #x5915 #x7A05 #x6D19 #x4E1E #x96D9 #x63F6 #x8339
      #xF9A9 #x6C83 #x8B20 #x5143 #xF9CF #xF9DF #x54A8 #x6E3D #x7BC6 #x608C
      #x7F6A #x667A #x55DF #x617D #x7A0D #x8106 #x7DBB #x6D7F #x75B2 #x5BB3
      #x834A #x64F4 #x5589 #xFFFE)
     (#x2225 #x2D9 #xFF0B #x313B #xFFFE #x253C #x3399 #x152 #x153 #x304B
      #x30AB #x419 #xFFFE #xFFFE #xFFFE #xAC13 #xAD34 #xAEC0 #xB099 #xB208
      #xB383 #xB55C #xB7B5 #xB98A #xBB34 #xBCB4 #xBE80 #xC110 #xC265 #xC479
      #xC5EE #xC714 #xC82D #xC9EC #xCC58 #xCE74 #xD070 #xD2A4 #xD479 #xD64D
      #xFFFE #x5BB6 #x5D17 #x683C #x8AA1 #x85FF #x61FC #x7AC5 #x6DC7 #xF92C
      #x6BB5 #x7A3B #xF95D #x52A3 #x7D2F #x9EBB #x8317 #x5473 #x5C28 #x908A
      #x7236 #x98DB #x9178 #x596D #x7B39 #x6F31 #x4E58 #x6C0F #x6930 #x8F3F
      #x584B #x7344 #x9059 #x539F #x7DAD #x5DF2 #x59C9 #x6ED3 #x7E8F #x63D0
      #x4E3B #x679D #x5D6F #x621A #x8096 #x81ED #x8A95 #x724C #x76AE #x61C8
      #x87A2 #x652B #x55C5 #xFFFE)
     (#xFF3C #xB8 #xFF0C #x313C #xFFFE #x2501 #x339A #xBA #xDF #x304C
      #x30AC #x41A #xFFFE #xFFFE #xFFFE #xAC14 #xAD35 #xAEC4 #xB09A #xB20B
      #xB384 #xB55D #xB7B8 #xB98D #xBB35 #xBCB5 #xBE84 #xC115 #xC26C #xC480
      #xC5F0 #xC715 #xC82F #xC9ED #xCC59 #xCE75 #xD074 #xD2AC #xD47C #xD651
      #xFFFE #x6687 #x5EB7 #x6A84 #x8C3F #x90ED #x62D8 #x7CFE #x7398 #x4E43
      #x6E4D #x8404 #x916A #x6D0C #x7E37 #x5BDE #x84C2 #x5A9A #x5E47 #x5225
      #x7B26 #x9F3B #x9730 #x5E2D #x7D30 #x71E7 #x50E7 #x4E9E #x723A #x8F5D
      #xF9AA #x7389 #xF9C3 #x54E1 #x81FE #x5F1B #x59FF #x707D #x8A6E #x68AF
      #x4F4F #x67B3 #x5DEE #x62D3 #x8278 #x8DA3 #x596A #x72FD #x88AB #x6977
      #x8861 #x78BA #x5E3F #xFFFE)
     (#x223C #x2DB #xFF0D #x313D #xFFFE #x2503 #x339B #xDE #xFE #x304D
      #x30AD #x41B #xFFFE #xFFFE #xFFFE #xAC15 #xAD38 #xAECC #xB09C #xB20C
      #xB385 #xB55F #xB7C7 #xB98E #xBB36 #xBCBC #xBE8C #xC11C #xC26D #xC494
      #xC5F4 #xC717 #xC831 #xC9EF #xCC60 #xCE78 #xD07C #xD2B1 #xD47F #xD654
      #xFFFE #x67B6 #x5F3A #x6FC0 #x968E #xF905 #x6551 #x8475 #x7426 #xF92D
      #x77ED #x89A9 #x99F1 #x70C8 #x851E #x5E55 #x879F #x5C3E #x5F77 #x77A5
      #x7C3F #x56AC #x4E77 #x60DC #xF96F #x72E9 #x52DD #x4FC4 #x8036 #xF986
      #xF9AB #x923A #x9080 #x5713 #x8438 #x5F5B #x5B50 #x7E21 #x8F3E #x6FDF
      #x4F8F #x6B62 #x6B21 #x64F2 #x82D5 #x9189 #x812B #x7A17 #x907F #x6D77
      #x9008 #x78BB #x5F8C #xFFFE)
     (#x2018 #xA1 #xFF0E #x313E #xFFFE #x250F #x339C #x166 #x167 #x304E
      #x30AE #x41C #xFFFE #xFFFE #xFFFE #xAC16 #xAD3C #xAECD #xB09F #xB214
      #xB38C #xB560 #xB7C9 #xB9AC #xBB38 #xBCBD #xBE8D #xC11D #xC270 #xC49C
      #xC5F6 #xC719 #xC838 #xC9F0 #xCC64 #xCE7C #xD07D #xD2B8 #xD480 #xD655
      #xFFFE #x67B7 #x5F4A #x8188 #x9DC4 #x51A0 #x67B8 #x898F #x742A #x5167
      #x7AEF #x8CED #xF95E #x88C2 #x8938 #x6F20 #x9169 #x5D4B #x623F #x9C49
      #x7F36 #x5B2A #x6492 #x6614 #x8CB0 #x7378 #x5347 #x5152 #xF974 #x9918
      #x5DB8 #x6EAB #x9952 #x5712 #x88D5 #x6021 #x5B57 #x88C1 #x8F49 #x796D
      #x505A #x6C60 #x6B64 #x65A5 #x8349 #x9A5F #x63A2 #x8987 #x9642 #x7023
      #x90A2 #x7A6B #x673D #xFFFE)
     (#x2019 #xBF #xFF0F #x313F #xFFFE #x2513 #x339D #x14A #x14B #x304F
      #x30AF #x41D #xFFFE #xFFFE #xFFFE #xAC17 #xAD44 #xAECF #xB0A0 #xB215
      #xB390 #xB561 #xB7EC #xB9AD #xBB3B #xBCC0 #xBE8F #xC11E #xC274 #xC4B8
      #xC5F7 #xC720 #xC83C #xC9F1 #xCC66 #xCE84 #xD081 #xD2B9 #xD482 #xD658
      #xFFFE #x67EF #x6177 #x89A1 #x53E4 #x5B98 #x67E9 #x8D73 #x7482 #x5948
      #x7C1E #x8DF3 #x4E82 #x5EC9 #x93E4 #x819C #x9298 #x5F4C #x653E #x9F08
      #x8150 #x5F6C #x6BBA #x6673 #x53EC #x7407 #x627F #x555E #x91CE #xF987
      #x5F71 #x7465 #x617E #x57A3 #x8A98 #xF9E0 #x5B5C #x8CA1 #x923F #x7B2C
      #x59DD #x6C9A #x78CB #x6ECC #x8549 #x9DF2 #x7708 #x8C9D #x5339 #x87F9
      #x93A3 #x4E38 #x7166 #xFFFE)
     (#x201C #x2D0 #xFF10 #x3140 #x2160 #x251B #x339E #xFFFE #x149 #x3050
      #x30B0 #x41E #xFFFE #xFFFE #xFFFE #xAC19 #xAD45 #xAED0 #xB0A1 #xB217
      #xB394 #xB5A0 #xB7ED #xB9B0 #xBB3C #xBCC4 #xBE90 #xC11F #xC27C #xC4BC
      #xC5FC #xC721 #xC840 #xC9F8 #xCC68 #xCE85 #xD0A4 #xD2BC #xD488 #xD65C
      #xFFFE #x6B4C #x6C5F #x9694 #x53E9 #x5BEC #x69CB #x9035 #x74A3 #x67F0
      #x7DDE #x8E48 #x5375 #x6582 #x964B #x83AB #x9CF4 #x5FAE #x65B9 #x4E19
      #x8151 #x658C #x715E #x6790 #x562F #x74B2 #x6607 #x5A25 #x5F31 #xF988
      #xF9AC #x761F #x6B32 #x5A9B #x8ADB #xF9E1 #x6063 #x8F09 #x9293 #x81CD
      #x80C4 #x6F2C #x7B9A #x7620 #x8C82 #x5074 #x803D #x5F6D #x5F3C #x89E3
      #x99A8 #x559A #x73DD #xFFFE)
     (#x201D #x222E #xFF11 #x3141 #x2161 #x2517 #x339F #x3260 #x3200 #x3051
      #x30B1 #x41F #xFFFE #xFFFE #xFFFE #xAC1A #xAD47 #xAED1 #xB0A2 #xB219
      #xB3A0 #xB5A1 #xB7F0 #xB9B4 #xBB3D #xBCCD #xBE91 #xC120 #xC27D #xC4E9
      #xC5FD #xC724 #xC848 #xC9F9 #xCC70 #xCE87 #xD0A5 #xD2BF #xD489 #xD667
      #xFFFE #x73C2 #x757A #x5805 #x544A #x6163 #x6B50 #x95A8 #x7578 #x8010
      #x86CB #x9003 #x6B04 #x6BAE #x5289 #x9088 #x8882 #x672A #x65C1 #x5002
      #x819A #x6AB3 #x85A9 #x6C50 #x5851 #x7626 #x7E69 #x5CE8 #xF975 #xF989
      #x6620 #x7A69 #x6D74 #x5AC4 #x8AED #xF9E2 #x6148 #x9F4B #x9322 #x85BA
      #x546A #x77E5 #xF9FE #x810A #x8D85 #x4EC4 #x8CAA #x6F8E #x5FC5 #x8A72
      #x516E #x5950 #x9005 #xFFFE)
     (#x3014 #x2211 #xFF12 #x3142 #x2162 #x2523 #x33A0 #x3261 #x3201 #x3052
      #x30B2 #x420 #xFFFE #xFFFE #xFFFE #xAC1B #xAD49 #xAED8 #xB0A8 #xB220
      #xB3A1 #xB5A4 #xB7F4 #xB9BC #xBB3E #xBCCF #xBE98 #xC123 #xC27F #xC4F0
      #xC5FE #xC728 #xC849 #xC9FC #xCC75 #xCE89 #xD0A8 #xD2C0 #xD48B #xD669
      #xFFFE #x75C2 #x7586 #x727D #x5471 #x68FA #x6BC6 #x52FB #x757F #xF92E
      #x8892 #x9014 #x6B12 #x6FC2 #x65D2 #x4E07 #x4FAE #x68B6 #x6609 #x5175
      #x8240 #x6BAF #x4E09 #x6DC5 #x5BB5 #x7761 #x8805 #x6211 #xF976 #x4EA6
      #x668E #x7E15 #x7E1F #x5BC3 #x8E30 #xF9E3 #x6ECB #x9F4E #x942B #x88FD
      #x5468 #x7825 #x8E49 #x8E60 #x9162 #x53A0 #x5854 #x70F9 #x6CCC #x8AE7
      #x5F57 #x5BA6 #x52DB #xFFFE)
     (#x3015 #x220F #xFF13 #x3143 #x2163 #x2533 #x33A1 #x3262 #x3202 #x3053
      #x30B3 #x421 #xFFFE #xFFFE #xFFFE #xAC1C #xAD50 #xAED9 #xB0A9 #xB234
      #xB3A8 #xB5A8 #xB7FC #xB9BD #xBB44 #xBCD0 #xBE99 #xC124 #xC281 #xC4F1
      #xC5FF #xC730 #xC84C #xCA00 #xCC98 #xCE90 #xD0AC #xD2C2 #xD48D #xD670
      #xFFFE #x7A3C #x7CE0 #x72AC #x56FA #x6B3E #x6BEC #x5747 #x7881 #x5973
      #x9132 #x9053 #x703E #x7C3E #x67F3 #x534D #x5192 #x6963 #x678B #x5C5B
      #x8299 #x6D5C #xF96B #x6F5F #x5C0F #x79C0 #x965E #x7259 #x7D04 #xF98A
      #x6979 #x860A #x8925 #x6028 #x8E42 #x723E #x7099 #x722D #x96FB #x8AF8
      #x55FE #x7949 #x8ECA #x965F #x918B #x60FB #x642D #x81A8 #x73CC #x9082
      #x60E0 #x5E7B #x52F3 #xFFFE)
     (#x3008 #xA4 #xFF14 #x3144 #x2164 #x252B #x33A2 #x3263 #x3203 #x3054
      #x30B4 #x422 #xFFFE #xFFFE #xFFFE #xAC1D #xAD54 #xAEDC #xB0AB #xB23C
      #xB3AC #xB5AA #xB7FD #xB9BF #xBB45 #xBCD1 #xBEA8 #xC126 #xC288 #xC4F4
      #xC600 #xC731 #xC84D #xCA08 #xCC99 #xCE91 #xD0B4 #xD2C8 #xD494 #xD671
      #xFFFE #x82DB #x7D73 #x7504 #x59D1 #x704C #x6C42 #x7547 #x78EF #x5E74
      #x935B #x90FD #x721B #x7375 #x69B4 #x5A29 #x52DF #x6E3C #x699C #x5E77
      #x83A9 #x6FF1 #x6749 #x77F3 #x5C11 #x7A57 #x4F8D #x82BD #x82E5 #x57DF
      #x69AE #x5140 #x8FB1 #x613F #x904A #x73E5 #x716E #x7B8F #x985A #x8E44
      #x594F #x7957 #x906E #x96BB #x91AE #x6E2C #x69BB #x610E #x7562 #x99ED
      #x6167 #x60A3 #x5864 #xFFFE)
     (#x3009 #x2109 #xFF15 #x3145 #x2165 #x253B #x33CA #x3264 #x3204 #x3055
      #x30B5 #x423 #xFFFE #xFFFE #xFFFE #xAC20 #xAD58 #xAEE8 #xB0AC #xB258
      #xB3C4 #xB5AB #xB7FF #xB9C1 #xBB47 #xBCD5 #xBED0 #xC127 #xC289 #xC4F8
      #xC601 #xC733 #xC854 #xCA09 #xCC9C #xCE94 #xD0B5 #xD2C9 #xD4A9 #xD674
      #xFFFE #x8304 #x7DB1 #x7D79 #x5B64 #x742F #x6E9D #x7B60 #x7941 #x649A
      #x64BB #x934D #x862D #x4EE4 #x6D41 #x5DD2 #x59C6 #x6E44 #x6EC2 #x661E
      #x8A03 #x7015 #x68EE #x78A9 #x5DE2 #x7AEA #x5319 #x83AA #x846F #x5F79
      #x6C38 #x58C5 #x4FD1 #x63F4 #x903E #xF9E4 #x7386 #x8ACD #x986B #x918D
      #x5B99 #x7D19 #x6349 #x4EDF #x4FC3 #x5C64 #x5B95 #x4FBF #x758B #x9AB8
      #x66B3 #x63DB #x58CE #xFFFE)
     (#x300A #x2030 #xFF16 #x3146 #x2166 #x254B #x338D #x3265 #x3205 #x3056
      #x30B6 #x424 #xFFFE #xFFFE #xFFFE #xAC24 #xAD61 #xAEEB #xB0AD #xB25C
      #xB3C5 #xB5B0 #xB800 #xB9C8 #xBB49 #xBCD8 #xBED1 #xC12C #xC290 #xC4FA
      #xC605 #xC735 #xC870 #xCA0B #xCCA0 #xCE98 #xD0B7 #xD2CB #xD4CC #xD683
      #xFFFE #x8857 #x7F8C #x7E6D #x5C3B #x74D8 #x7078 #x83CC #x7947 #x79CA
      #x6FBE #x9676 #x9E1E #x4F36 #x6E9C #x5F4E #x5E3D #x7709 #x78C5 #x663A
      #x8CA0 #x725D #x6E17 #x84C6 #x6240 #x7CB9 #x5636 #x86FE #x84BB #x6613
      #x6CF3 #x64C1 #x50AD #x6C85 #x907A #x7570 #x74F7 #x931A #x991E #x9664
      #x5DDE #x80A2 #x643E #x5343 #x56D1 #x4F88 #x5E11 #x504F #x7B46 #x52BE
      #x8559 #x6B61 #x7104 #xFFFE)
     (#x300B #x25C1 #xFF17 #x3147 #x2167 #x2520 #x338E #x3266 #x3206 #x3057
      #x30B7 #x425 #xFFFE #xFFFE #xFFFE #xAC2C #xAD63 #xAEED #xB0AE #xB260
      #xB3C8 #xB5B1 #xB801 #xB9C9 #xBB4D #xBCDC #xBED4 #xC12D #xC298 #xC4FF
      #xC606 #xC737 #xC871 #xCA0C #xCCA8 #xCEA0 #xD0B9 #xD2D4 #xD4D0 #xD685
      #xFFFE #x8888 #x8154 #x80A9 #x5EAB #x7BA1 #x72D7 #x921E #x7948 #x5FF5
      #x737A #x97DC #x524C #x56F9 #x700F #x6162 #x6155 #x7C73 #x7D21 #x67C4
      #x8CE6 #x73AD #x829F #x91CB #x6383 #x7D8F #x59CB #x8859 #x85E5 #xF98B
      #x6E36 #x74EE #x5197 #x6D39 #x9149 #x75CD #x75B5 #x4F47 #x5207 #x969B
      #x5EDA #x8102 #x7740 #x5598 #x71ED #x5024 #x6E6F #x6241 #x82FE #x6838
      #x8E4A #x6665 #x718F #xFFFE)
     (#x300C #x25C0 #xFF18 #x3148 #x2168 #x252F #x338F #x3267 #x3207 #x3058
      #x30B8 #x426 #xFFFE #xFFFE #xFFFE #xAC2D #xAD6C #xAEF4 #xB0AF #xB268
      #xB3CB #xB5B3 #xB807 #xB9CC #xBB4F #xBCF4 #xBED7 #xC12F #xC29B #xC500
      #xC607 #xC73C #xC874 #xCA0D #xCCA9 #xCEA1 #xD0C0 #xD2D8 #xD4D4 #xD68C
      #xFFFE #x8A36 #x8221 #x898B #x62F7 #x7F50 #x7396 #xF908 #x797A #x606C
      #x75B8 #x6BD2 #x8FA3 #xF95F #x7409 #x633D #x6478 #x7F8E #x80AA #x68C5
      #x8CFB #x8CA7 #x8518 #x932B #x6414 #x7DAC #x5AA4 #x8A1D #x8E8D #xF98C
      #x6F41 #x7515 #x52C7 #x6E72 #x91C9 #xF9E5 #x78C1 #x4F4E #x622A #x973D
      #x665D #x81F3 #x7A84 #x5929 #x77D7 #x55E4 #xFA03 #x7247 #x999D #x5016
      #x91AF #x6853 #x71FB #xFFFE)
     (#x300D #x25B7 #xFF19 #x3149 #x2169 #x2528 #x33CF #x3268 #x3208 #x3059
      #x30B9 #x427 #xFFFE #xFFFE #xFFFE #xAC2F #xAD6D #xAEF8 #xB0B1 #xB269
      #xB3CC #xB5B4 #xB808 #xB9CE #xBB50 #xBCF5 #xBED8 #xC130 #xC29D #xC501
      #xC608 #xC73D #xC878 #xCA14 #xCCAB #xCEA3 #xD0C1 #xD2DC #xD4DC #xD68D
      #xFFFE #x8CC8 #x8591 #x8B74 #x6537 #x83C5 #x7403 #x6A58 #x7B95 #x62C8
      #x9054 #x7006 #x5D50 #x5CBA #x7460 #x6669 #x6479 #x8587 #x8180 #x70B3
      #x8D74 #x8CD3 #x886B #x4ED9 #x662D #x7E61 #x5C38 #x963F #xF977 #x75AB
      #x6FDA #x7670 #x57C7 #x6E90 #x936E #x79FB #x7D2B #x5132 #x6298 #x984C
      #x6731 #x829D #x932F #x5DDD #x8700 #x5CD9 #x8569 #x7BC7 #x4E4F #x5E78
      #x978B #x6E19 #x85B0 #xFFFE)
     (#x300E #x25B6 #xFF1A #x314A #xFFFE #x2537 #x3388 #x3269 #x3209 #x305A
      #x30BA #x428 #xFFFE #xFFFE #xFFFE #xAC30 #xAD70 #xAEFC #xB0B3 #xB274
      #xB3CE #xB5B5 #xB809 #xB9CF #xBB54 #xBCF6 #xBEE0 #xC131 #xC2A4 #xC50C
      #xC60C #xC740 #xC87A #xCA18 #xCCAC #xCEA4 #xD0C4 #xD2E4 #xD4DF #xD690
      #xFFFE #x8DCF #x8941 #x9063 #x6545 #x89C0 #x77BF #x514B #x7D00 #x637B
      #x5556 #x7258 #x64E5 #x5DBA #x7559 #x66FC #x66AE #x8B0E #x822B #x7501
      #x8DBA #x983B #x63F7 #x50CA #x68B3 #x7F9E #x5C4E #x96C5 #x4F6F #x7E79
      #x701B #x7FC1 #x5889 #x7230 #xF9D0 #xF9E6 #x8005 #x5480 #x6D59 #x9F4A
      #x67F1 #x82B7 #x947F #x64C5 #x89F8 #x5E5F #x514C #x7DE8 #x903C #x674F
      #x4E4E #x7165 #x8A13 #xFFFE)
     (#x300F #x2664 #xFF1B #x314B #xFFFE #x253F #x3389 #x326A #x320A #x305B
      #x30BB #x429 #xFFFE #xFFFE #xFFFE #xAC31 #xAD73 #xAF07 #xB0B4 #xB275
      #xB3D0 #xB5BB #xB80C #xB9D0 #xBB58 #xBCF8 #xBEE3 #xC136 #xC2A5 #xC510
      #xC610 #xC744 #xC880 #xCA29 #xCCAD #xCEA5 #xD0C8 #xD2E5 #xD4E8 #xD694
      #xFFFE #x8EFB #x8B1B #x9D51 #x6572 #x8CAB #x77E9 #x524B #x7DBA #x5BE7
      #x574D #x72A2 #x652C #x601C #x7624 #x6EFF #x67D0 #x8FF7 #x82B3 #x75C5
      #x90E8 #x6191 #x6F81 #x5148 #x6CBC #x8129 #x5C4D #x9913 #xF978 #x8B6F
      #x702F #x9095 #x5BB9 #x733F #xF9D1 #x800C #x81EA #x59D0 #x7664 #x4FCE
      #x682A #x8718 #x9F6A #x6CC9 #x5BF8 #x6065 #x53F0 #x7FE9 #x4E0B #x8347
      #x4E92 #x74B0 #x6688 #xFFFE)
     (#x3010 #x2660 #xFF1C #x314C #xFFFE #x251D #x33C8 #x326B #x320B #x305C
      #x30BC #x42A #xFFFE #xFFFE #xFFFE #xAC38 #xAD74 #xAF08 #xB0B5 #xB27C
      #xB3D4 #xB5BC #xB810 #xB9D1 #xBB61 #xBCFC #xBEE4 #xC138 #xC2A8 #xC514
      #xC618 #xC74A #xC881 #xCA4C #xCCB4 #xCEAC #xD0C9 #xD2F0 #xD4EC #xD69D
      #xFFFE #x8FE6 #x92FC #x6289 #x66A0 #x95DC #x7A76 #x5287 #x7F88 #x5BD7
      #x61BA #x7368 #x6B16 #x73B2 #x786B #x6F2B #x6A21 #x9761 #x84A1 #x79C9
      #x91DC #x6C37 #x9212 #x5584 #x6D88 #x8331 #x5E02 #x9D09 #xF979 #xF98D
      #x7150 #x96CD #x5EB8 #x7457 #x5809 #x8033 #x8328 #x5E95 #x7ACA #x5146
      #x6CE8 #x8A8C #x64B0 #x6DFA #x5FD6 #x6894 #x592A #x904D #x4F55 #x884C
      #x547C #x7D08 #x85A8 #xFFFE)
     (#x3011 #x2661 #xFF1D #x314D #xFFFE #x2530 #x33A7 #x326C #x320C #x305D
      #x30BD #x42B #xFFFE #xFFFE #xFFFE #xAC39 #xAD75 #xAF0D #xB0B8 #xB284
      #xB3D5 #xB5BD #xB818 #xB9D2 #xBB63 #xBD04 #xBEE5 #xC139 #xC2AC #xC51C
      #xC619 #xC74C #xC883 #xCA4D #xCCB5 #xCEAD #xD0D0 #xD2F1 #xD4F0 #xD69F
      #xFFFE #x99D5 #x964D #x6C7A #x67AF #x9928 #x7D7F #x621F #x8006 #x52AA
      #x64D4 #x7763 #x6FEB #x7B2D #x8B2C #x7063 #x6BCD #x9EF4 #x868C #x7ADD
      #x961C #x8058 #x98AF #x5B0B #x6EAF #x8490 #x5F11 #x9D5D #x58E4 #x9006
      #x71DF #x9954 #x6142 #x82D1 #xF9D2 #x8084 #x8517 #x62B5 #x7BC0 #x51CB
      #x6D32 #xF9FC #x6FAF #x7394 #x6751 #x6CBB #x6020 #x97AD #x53A6 #x4EAB
      #x58D5 #x9084 #x55A7 #xFFFE)
     (#xB1 #x2665 #xFF1E #x314E #xFFFE #x2525 #x33A8 #x326D #x320D #x305E
      #x30BE #x42C #xFFFE #xFFFE #xFFFE #xAC3C #xAD76 #xAF10 #xB0BC #xB285
      #xB3D7 #xB5C0 #xB819 #xB9D8 #xBB6C #xBD05 #xBEEC #xC13C #xC2AD #xC528
      #xC61B #xC74D #xC885 #xCA50 #xCCB8 #xCEC1 #xD0D1 #xD2F4 #xD4F8 #xD6A1
      #xFFFE #x523B #x9C47 #x6F54 #x69C1 #x522E #x8009 #x68D8 #x802D #xF92F
      #x66C7 #x79BF #x7C43 #x7F9A #x985E #x779E #x6BDB #x5CB7 #x8A2A #x8F27
      #x9644 #x9A01 #x4E0A #x5BA3 #x701F #x84DA #x6043 #x580A #x5B43 #x9A5B
      #x7370 #x6E26 #x6995 #x8881 #x6BD3 #x82E1 #x85C9 #x6775 #x7D76 #x52A9
      #x6E4A #x8D04 #x71E6 #x7A7F #x90A8 #x6DC4 #x614B #x9A19 #x590F #x5411
      #x58FA #x9A69 #x6684 #xFFFE)
     (#xD7 #x2667 #xFF1F #x314F #xFFFE #x2538 #x33B0 #x326E #x320E #x305F
      #x30BF #x42D #xFFFE #xFFFE #xFFFE #xAC40 #xAD7B #xAF2C #xB0C4 #xB289
      #xB3D9 #xB5C4 #xB81B #xB9D9 #xBB88 #xBD07 #xBF01 #xC140 #xC2B4 #xC529
      #xC61C #xC74F #xC886 #xCA54 #xCCBC #xCEE4 #xD0D3 #xD2F8 #xD4FB #xD6A8
      #xFFFE #x5374 #x4ECB #x7D50 #x6CBD #x605D #x81FC #x6975 #x808C #x5974
      #x6DE1 #x7BE4 #x7E9C #x7FCE #x516D #x842C #x725F #x60B6 #x8B17 #x9920
      #x99D9 #x4E4D #x50B7 #x6247 #x70A4 #x85EA #x65BD #x5CB3 #x6059 #x56A5
      #xF9AD #x74E6 #x6D8C #x8F45 #x8089 #x8351 #x8AEE #x696E #x5360 #x5632
      #x6F8D #x8DBE #x74A8 #x821B #x53E2 #x71BE #x6B86 #x8CB6 #x5EC8 #x56AE
      #x597D #x9C25 #x714A #xFFFE)
     (#xF7 #x2663 #xFF20 #x3150 #xFFFE #x2542 #x33B1 #x326F #x320F #x3060
      #x30C0 #x42E #xFFFE #xFFFE #xFFFE #xAC4B #xAD7C #xAF2D #xB0C5 #xB290
      #xB3DB #xB5CC #xB81D #xB9DB #xBB8C #xBD09 #xBF08 #xC148 #xC2B5 #xC52C
      #xC624 #xC751 #xC887 #xCA5C #xCCC4 #xCEE5 #xD0D4 #xD300 #xD4FD #xD6AC
      #xFFFE #x5404 #x4EF7 #x7F3A #x75FC #x62EC #x8205 #x9699 #x8A18 #x5F29
      #x6E5B #x7E9B #x85CD #x8046 #x622E #x8513 #x7261 #x610D #x90A6 #x9A08
      #x9CE7 #x4E8B #x50CF #x657E #x71D2 #x8896 #x662F #x5DBD #x63DA #x5827
      #x745B #x7AA9 #x6E67 #x9060 #x80B2 #xF9E7 #x8CC7 #x6A17 #x5CBE #x5F14
      #x70B7 #x9072 #x74DA #x85A6 #x585A #x75D4 #x6C70 #x576A #x6630 #x73E6
      #x5CB5 #x6D3B #x8431 #xFFFE)
     (#x2260 #x2299 #xFF21 #x3151 #x391 #x2512 #x33B2 #x3270 #x3210 #x3061
      #x30C1 #x42F #xFFFE #xFFFE #xFFFE #xAC4D #xAD7D #xAF30 #xB0C7 #xB291
      #xB3DD #xB5CD #xB824 #xB9DD #xBB90 #xBD10 #xBF09 #xC149 #xC2B7 #xC530
      #xC625 #xC752 #xC88B #xCA5D #xCCC5 #xCEE8 #xD0D5 #xD301 #xD504 #xD6B0
      #xFFFE #x606A #x500B #x8A23 #x7690 #x9002 #x820A #x50C5 #x8B4F #x6012
      #x6F6D #x8B80 #x8964 #x901E #x9678 #x883B #x7441 #x61AB #x9632 #x4FDD
      #x5317 #x4E9B #x511F #x65CB #x7526 #x8AB0 #x6642 #x5E44 #x6518 #x59F8
      #xF9AE #x7AAA #x6EB6 #xF9C6 #xF9D3 #xF9E8 #x96CC #x6CAE #x5E97 #x5F6B
      #x73E0 #x76F4 #x7AC4 #x8CE4 #x5BF5 #x75F4 #x6CF0 #x5E73 #x6CB3 #x9115
      #x5F27 #x6ED1 #x5349 #xFFFE)
     (#x2264 #x25C8 #xFF22 #x3152 #x392 #x2511 #x33B3 #x3271 #x3211 #x3062
      #x30C2 #xFFFE #xFFFE #xFFFE #xFFFE #xAC54 #xAD7F #xAF32 #xB0C8 #xB294
      #xB3E0 #xB5CF #xB825 #xB9DE #xBBA4 #xBD14 #xBF18 #xC14B #xC2B9 #xC538
      #xC628 #xC753 #xC88C #xCA5F #xCCC7 #xCEEB #xD0DC #xD303 #xD508 #xD6B9
      #xFFFE #x6164 #x51F1 #x517C #x777E #x4F8A #x82DF #x52A4 #x8C48 #xF930
      #x6FB9 #x58A9 #x89BD #x9234 #x4F96 #x8F13 #x7738 #x654F #x9F90 #x5821
      #x5206 #x4ED5 #x5546 #x6E32 #x758F #x8B90 #x67BE #x60E1 #x656D #x5A1F
      #x74D4 #x81E5 #x7194 #x9662 #xF9D4 #x8CBD #x4F5C #x6E1A #x6F38 #x63AA
      #x7587 #x7A19 #x7C12 #x8E10 #x60A4 #x7661 #x7B1E #x67B0 #x7455 #x97FF
      #x6236 #x733E #x5599 #xFFFE)
     (#x2265 #x25A3 #xFF23 #x3153 #x393 #x251A #x33B4 #x3272 #x3212 #x3063
      #x30C3 #xFFFE #xFFFE #xFFFE #xFFFE #xAC58 #xAD81 #xAF34 #xB0C9 #xB298
      #xB3E4 #xB5D0 #xB828 #xB9E1 #xBBA8 #xBD24 #xBF19 #xC14C #xC2DC #xC539
      #xC62C #xC754 #xC88D #xCA60 #xCCC9 #xCEEC #xD0DD #xD305 #xD50C #xD6BB
      #xFFFE #x6BBC #x584F #x614A #x7A3F #x5149 #x8862 #x52E4 #x8D77 #xF931
      #x75F0 #x60C7 #x62C9 #x96F6 #x502B #x9945 #x77DB #x65FB #x500D #x5831
      #x5429 #x4F3A #x55AA #x717D #x758E #x8F38 #x67F4 #x6115 #x6698 #x5BB4
      #x76C8 #x86D9 #x7462 #x9858 #x5141 #x8CB3 #x52FA #x72D9 #x70B9 #x64CD
      #x7C4C #x7A37 #x7E82 #x9077 #x6181 #x7A1A #x80CE #x840D #x8377 #x9909
      #x6248 #x8C41 #x6BC1 #xFFFE)
     (#x221E #x25D0 #xFF24 #x3154 #x394 #x2519 #x33B5 #x3273 #x3213 #x3064
      #x30C4 #xFFFE #xFFFE #xFFFE #xFFFE #xAC5C #xAD82 #xAF3C #xB0D0 #xB299
      #xB3E8 #xB5D1 #xB82C #xB9E3 #xBBAC #xBD2C #xBF1B #xC14D #xC2DD #xC53B
      #xC62D #xC755 #xC894 #xCA61 #xCCD0 #xCEF4 #xD0E0 #xD30C #xD514 #xD6C4
      #xFFFE #x73CF #x6137 #x7B9D #x7F94 #x5321 #x8B33 #x61C3 #x9321 #xF932
      #x8043 #x6566 #x81D8 #x9748 #x5D19 #x9C3B #x8017 #x65FC #x4FF3 #x5BF6
      #x5674 #x4F3C #x5617 #x7401 #x7619 #x9042 #x731C #x63E1 #xF97A #xF98E
      #x7A4E #x8778 #x7528 #x9D1B #x596B #x9087 #x56BC #x732A #x7C98 #x65E9
      #x7D02 #x7E54 #x7CB2 #x91E7 #x6460 #x7A49 #x82D4 #x8A55 #x8766 #x9957
      #x660A #x95CA #x5F59 #xFFFE)
     (#x2234 #x25D1 #xFF25 #x3155 #x395 #x2516 #x33B6 #x3274 #x3214 #x3065
      #x30C5 #xFFFE #xFFFE #xFFFE #xFFFE #xAC70 #xAD88 #xAF3D #xB0D1 #xB29A
      #xB3FC #xB5D8 #xB834 #xB9E4 #xBBB4 #xBD40 #xBF1C #xC154 #xC2E0 #xC53D
      #xC62E #xC756 #xC89D #xCA68 #xCCD4 #xCEF5 #xD0E4 #xD30D #xD515 #xD6C5
      #xFFFE #x811A #x613E #x8B19 #x8003 #x58D9 #x8CFC #x65A4 #x9324 #x7459
      #x81BD #x65FD #x881F #x9818 #x6DEA #x551C #x82BC #x6C11 #xF963 #x666E
      #x58B3 #x4F7F #x5B40 #x7444 #x7B11 #x9083 #x77E2 #x6A02 #x694A #x5EF6
      #x7E93 #x8A1B #x752C #x6708 #x5C39 #xF9E9 #x65AB #x75BD #x9711 #x6641
      #x7D2C #x8077 #x7E98 #x95E1 #x7E3D #x7DC7 #x8DC6 #x5420 #x8CC0 #x9999
      #x6667 #x51F0 #x5FBD #xFFFE)
     (#xB0 #x2592 #xFF26 #x3156 #x396 #x2515 #x33B7 #x3275 #x3215 #x3066
      #x30C6 #xFFFE #xFFFE #xFFFE #xFFFE #xAC71 #xAD89 #xAF3F #xB0D4 #xB2A0
      #xB410 #xB5EC #xB835 #xB9E5 #xBBB7 #xBD48 #xBF1D #xC155 #xC2E3 #xC544
      #xC630 #xC757 #xC89F #xCA7D #xCCE4 #xCEF7 #xD0EC #xD30E #xD517 #xD6C8
      #xFFFE #x89BA #x6168 #x9257 #x80A1 #x5EE3 #x8EC0 #x6839 #x98E2 #xF933
      #x8541 #x66BE #x5ECA #x9F61 #x7DB8 #x62B9 #x8305 #x6CEF #x57F9 #x6B65
      #x5954 #x4FDF #x5C19 #x7487 #x7BE0 #x916C #x793A #x6E25 #x6A23 #xF98F
      #xF9AF #x5A49 #x8073 #x8D8A #xF9D5 #xF9EA #x6628 #x7BB8 #x9B8E #x66FA
      #x7DA2 #x5507 #x8B9A #x9621 #x8070 #x7DFB #x90B0 #x5B16 #x9050 #x5653
      #x6BEB #x5E4C #x63EE #xFFFE)
     (#x2032 #x25A4 #xFF27 #x3157 #x397 #x250E #x33B8 #x3276 #x3216 #x3067
      #x30C7 #xFFFE #xFFFE #xFFFE #xFFFE #xAC74 #xAD8C #xAF41 #xB0D8 #xB2A1
      #xB418 #xB610 #xB837 #xB9E8 #xBBC0 #xBD49 #xBF40 #xC158 #xC2E4 #xC545
      #xC633 #xC758 #xC8A1 #xCA84 #xCCEC #xCEF8 #xD0ED #xD310 #xD53C #xD6CC
      #xFFFE #x89D2 #x6539 #x938C #x818F #x66E0 #x9011 #x69FF #x9951 #xF934
      #x8983 #x6C8C #x6717 #x4F8B #x8F2A #x672B #x8B00 #x739F #x5F98 #x6D11
      #x596E #x50FF #x5CE0 #x74BF #x7C2B #x9296 #x7FC5 #x9102 #x6D0B #xF990
      #xF9B0 #x5B8C #x8338 #x925E #xF9D6 #x98F4 #x707C #x7D35 #x9EDE #x66F9
      #x821F #x55D4 #x8D0A #x97C6 #x8525 #x7F6E #x98B1 #x5E63 #x971E #x589F
      #x6D69 #x5FA8 #x6689 #xFFFE)
     (#x2033 #x25A5 #xFF28 #x3158 #x398 #x250D #x33B9 #x3277 #x3217 #x3068
      #x30C8 #xFFFE #xFFFE #xFFFE #xFFFE #xAC77 #xAD90 #xAF42 #xB0E0 #xB2A3
      #xB41C #xB611 #xB838 #xB9EC #xBBC4 #xBD4C #xBF41 #xC15C #xC2EB #xC548
      #xC634 #xC75C #xC8A8 #xCA98 #xCCF0 #xCEF9 #xD0EF #xD314 #xD53D #xD6D1
      #xFFFE #x95A3 #x69EA #x4EAC #x82E6 #x6D38 #x90B1 #x747E #x9A0E #xF935
      #x8AC7 #x711E #x6D6A #x6FA7 #x5F8B #x6CAB #x8B28 #x73C9 #x62DC #x6E7A
      #x5FFF #x53F2 #x5E38 #x766C #x7D20 #x92B9 #x8494 #x9354 #x7001 #x6350
      #x82F1 #x5B9B #x84C9 #x4F4D #x6F64 #x990C #x70B8 #x82E7 #x63A5 #x671D
      #x86DB #x5875 #x947D #x51F8 #x9283 #x81F4 #xFA04 #x5EE2 #x9C15 #x865B
      #x6DCF #x604D #x7147 #xFFFE)
     (#x2103 #x25A8 #xFF29 #x3159 #x399 #x251E #x3380 #x3278 #x3218 #x3069
      #x30C9 #xFFFE #xFFFE #xFFFE #xFFFE #xAC78 #xAD9C #xAF43 #xB0E5 #xB2A5
      #xB420 #xB614 #xB839 #xB9F4 #xBBC8 #xBD50 #xBF44 #xC164 #xC2EC #xC549
      #xC635 #xC760 #xC8BC #xCABC #xCD01 #xCF00 #xD0F0 #xD316 #xD540 #xD6D4
      #xFFFE #x4F83 #x6F11 #x4FD3 #x82FD #x709A #x9264 #x7B4B #x9A0F #xF936
      #x8B5A #x71C9 #x72FC #x79AE #x6144 #x8309 #x8C8C #x7DE1 #x6392 #x6F7D
      #x61A4 #x53F8 #x5E8A #x79AA #x7D39 #x968B #x84CD #x984E #x716C #x633B
      #x8A60 #x68A1 #x8E0A #x5049 #x73A7 #xF9EB #x7235 #x83F9 #x647A #x689D
      #x8A3B #x632F #x9910 #x54F2 #x64AE #x86A9 #x64C7 #x5F0A #x58D1 #x8A31
      #x6E56 #x60F6 #x8AF1 #xFFFE)
     (#x212B #x25A7 #xFF2A #x315A #x39A #x251F #x3381 #x3279 #x3219 #x306A
      #x30CA #xFFFE #xFFFE #xFFFE #xFFFE #xAC7A #xAD9D #xAF48 #xB108 #xB2A6
      #xB428 #xB618 #xB840 #xB9F5 #xBBD0 #xBD58 #xBF48 #xC165 #xC2ED #xC54A
      #xC637 #xC768 #xC8BD #xCABD #xCD08 #xCF01 #xD0F1 #xD31C #xD544 #xD6D7
      #xFFFE #x520A #x75A5 #x501E #x83F0 #x72C2 #x92B6 #x82B9 #x9A65 #xF937
      #x931F #x8C5A #x7405 #x91B4 #x6817 #x896A #x6728 #x9594 #x676F #x73E4
      #x626E #x5506 #x5EA0 #x7DDA #x852C #x96A7 #x8996 #x9C10 #x75D2 #xF991
      #x8FCE #x6900 #x9394 #x50DE #x80E4 #xF9EC #x7DBD #x8457 #x8776 #x68D7
      #x8A85 #x6422 #x994C #x5586 #x50AC #x8F1C #x6FA4 #x6583 #x5B78 #x61B2
      #x6EF8 #x6130 #x8F1D #xFFFE)
     (#xFFE0 #x25A6 #xFF2B #x315B #x39B #x2521 #x3382 #x327A #x321A #x306B
      #x30CB #xFFFE #xFFFE #xFFFE #xFFFE #xAC80 #xADA4 #xAF49 #xB109 #xB2AA
      #xB429 #xB625 #xB844 #xB9F7 #xBBD3 #xBD59 #xBF50 #xC167 #xC2EF #xC54C
      #xC639 #xC76B #xC8C4 #xCAC0 #xCD09 #xCF04 #xD0F8 #xD31D #xD54C #xD6D9
      #xFFFE #x58BE #x7686 #x50BE #x85C1 #x73D6 #x99D2 #x83EB #x9E92 #xF938
      #x6C93 #x9813 #x746F #x96B7 #xF961 #x977A #x6C90 #x5BC6 #x6E43 #x752B
      #x6610 #x55E3 #x5EC2 #x7E55 #x856D #x96A8 #x8A66 #x9F77 #x760D #x693D
      #xF9B1 #x6D63 #x93DE #x5371 #x8D07 #x7037 #x828D #x85F7 #x4E01 #x69FD
      #x8D70 #x6649 #x5239 #x5FB9 #x5D14 #x96C9 #x6491 #x80BA #x8650 #x6AF6
      #x6F94 #x614C #x9EBE #xFFFE)
     (#xFFE1 #x25A9 #xFF2C #x315C #x39C #x2522 #x3383 #x327B #x321B #x306C
      #x30CC #xFFFE #xFFFE #xFFFE #xFFFE #xAC81 #xADB7 #xAF50 #xB10B #xB2AC
      #xB42B #xB62C #xB851 #xB9F8 #xBBF8 #xBD64 #xBF51 #xC168 #xC2F1 #xC54D
      #xC63B #xC774 #xC8C8 #xCAC4 #xCD0C #xCF08 #xD10D #xD31F #xD54D #xD6E0
      #xFFFE #x5978 #x76D6 #x5106 #x8831 #x7B50 #x9A45 #x89B2 #x7DCA #x99D1
      #x7553 #x4E6D #x8782 #x52DE #x9686 #x4EA1 #x7267 #x871C #x7119 #x83E9
      #x6C7E #x56DB #x60F3 #x7FA8 #x8607 #x96D6 #x8A69 #x5B89 #x79B3 #x6C87
      #x9348 #x73A9 #xF9C4 #x570D #xF9D7 #x76CA #x914C #x8A5B #x4E95 #x6F15
      #x8E8A #x664B #x5BDF #x64A4 #x6700 #x99B3 #x6504 #x853D #x8B14 #x737B
      #x6FE0 #x6643 #x4F11 #xFFFE)
     (#xFFE5 #x2668 #xFF2D #x315D #x39D #x2526 #x3384 #x24D0 #x249C #x306D
      #x30CD #xFFFE #xFFFE #xFFFE #xFFFE #xAC83 #xADC0 #xAF5C #xB10C #xB2B0
      #xB434 #xB634 #xB853 #xB9F9 #xBBF9 #xBD68 #xBF55 #xC169 #xC2F6 #xC54E
      #xC640 #xC775 #xC8CC #xCACC #xCD10 #xCF10 #xD130 #xD320 #xD54F #xD6E4
      #xFFFE #x59E6 #x7B87 #x52C1 #x88B4 #x80F1 #x9CE9 #x8B39 #x4F76 #xF939
      #x7B54 #x7A81 #x90DE #xF960 #x52D2 #x5984 #x76EE #x8B10 #x76C3 #x88DC
      #x711A #x58EB #x6851 #x817A #x8A34 #x9700 #x8AE1 #x5CB8 #x7A70 #x6CBF
      #xF9B2 #x7413 #x4E8E #x59D4 #x9217 #x7FCA #x96C0 #x8CAF #x4EAD #x6F6E
      #x8F33 #x686D #x64E6 #x6F88 #x589C #x9F52 #x514E #x9589 #x9DB4 #x8ED2
      #x6FE9 #x6644 #x643A #xFFFE)
     (#x2642 #x260F #xFF2E #x315E #x39E #x2527 #x33BA #x24D1 #x249D #x306E
      #x30CE #xFFFE #xFFFE #xFFFE #xFFFE #xAC84 #xADC1 #xAF5D #xB110 #xB2B4
      #xB450 #xB648 #xB85C #xB9FA #xBBFC #xBD80 #xBF94 #xC170 #xC2F8 #xC553
      #xC641 #xC778 #xC8D4 #xCACD #xCD18 #xCF11 #xD131 #xD321 #xD551 #xD6E8
      #xFFFE #x5E72 #x82A5 #x52CD #x8AA5 #x945B #x9DD7 #x8FD1 #x5409 #xF93A
      #x8E0F #x4EDD #x4F86 #x6488 #x808B #x5FD8 #x7766 #x525D #x80CC #x8913
      #x76C6 #x5962 #x6A61 #x81B3 #x900D #x9808 #x8C55 #x6309 #xF97B #x6D8E
      #x9719 #x742C #x4F51 #x5A01 #x958F #x7FCC #x9D72 #x8E87 #x505C #x7167
      #x9031 #x699B #x672D #x7DB4 #x62BD #x5247 #x5410 #x965B #x5BD2 #x6B47
      #x705D #x69A5 #x70CB #xFFFE)
     (#x2640 #x260E #xFF2F #x315F #x39F #x2529 #x33BB #x24D2 #x249E #x306F
      #x30CF #xFFFE #xFFFE #xFFFE #xFFFE #xAC85 #xADC4 #xAF64 #xB112 #xB2C8
      #xB451 #xB664 #xB85D #xBA00 #xBBFF #xBD81 #xBFB0 #xC174 #xC2F9 #xC554
      #xC644 #xC77C #xC8D5 #xCACF #xCD19 #xCF13 #xD134 #xD325 #xD558 #xD6F0
      #xFFFE #x5E79 #x84CB #x537F #xF903 #x5366 #x9F9C #x9949 #x62EE #xF93B
      #x905D #x51AC #x5D0D #x64C4 #x51DC #x5FD9 #x7A46 #x535A #x80DA #x8B5C
      #x7C89 #x5A11 #x6E58 #x8239 #x9061 #x9996 #x8C7A #x664F #x7F8A #x6D93
      #xF9B3 #x7897 #x5076 #x5C09 #xF9D8 #x7FFC #x5B71 #x9019 #x5075 #x71E5
      #x914E #x6B84 #x7D2E #x8F1F #x63A8 #x52C5 #x571F #x4F48 #x6068 #x96AA
      #x72D0 #x6CC1 #x7566 #xFFFE)
     (#x2220 #x261C #xFF30 #x3160 #x3A0 #x252A #x33BC #x24D3 #x249F #x3070
      #x30D0 #xFFFE #xFFFE #xFFFE #xFFFE #xAC86 #xADC8 #xAF65 #xB113 #xB2C9
      #xB454 #xB668 #xB860 #xBA01 #xBC00 #xBD84 #xBFC5 #xC178 #xC2FB #xC555
      #xC648 #xC77D #xC8D7 #xCAD1 #xCD1B #xCF15 #xD138 #xD328 #xD559 #xD6F5
      #xFFFE #x61C7 #xF900 #x5770 #x8F9C #x639B #x570B #xF909 #x6854 #xF93C
      #x5510 #x51CD #x5FA0 #x6AD3 #x51CC #x671B #x9DA9 #x62CD #x88F4 #x8F14
      #x7CDE #x5BEB #x723D #x861A #x90B5 #x9AD3 #x57F4 #x6848 #xF97C #x6DF5
      #xF9B4 #x7DE9 #x512A #x6170 #xF9D9 #x8B1A #x68E7 #x90B8 #x5448 #x722A
      #x9152 #x6D25 #x50ED #x8F4D #x690E #x98ED #x8A0E #x5305 #x608D #x9A57
      #x7425 #x6E5F #x8667 #xFFFE)
     (#x22A5 #x261E #xFF31 #x3161 #x3A1 #x252D #x33BD #x24D4 #x24A0 #x3071
      #x30D1 #x430 #xFFFE #xFFFE #xFFFE #xAC89 #xADD0 #xAF79 #xB118 #xB2CC
      #xB458 #xB69C #xB864 #xBA08 #xBC02 #xBD87 #xBFCC #xC185 #xC2FC #xC557
      #xC650 #xC77E #xC8D9 #xCAD3 #xCD1D #xCF1C #xD13A #xD329 #xD55C #xD6FC
      #xFFFE #x63C0 #x93A7 #x5883 #x932E #x7F6B #x5C40 #x4ECA #x91D1 #xF93D
      #x5802 #x52D5 #x840A #x6F5E #x695E #x7DB2 #x6B7F #x640F #x88F5 #x4F0F
      #x7D1B #x5BFA #x7240 #x87EC #x92B7 #x9B1A #x5BD4 #x773C #x8944 #x6F14
      #x4E42 #x7FEB #x53C8 #x6690 #xF9DA #x4EBA #x6B98 #x96CE #x59C3 #x74AA
      #x9444 #x6EB1 #x53C3 #x9435 #x6978 #x89AA #x615F #x530D #x65F1 #x5955
      #x745A #x6EC9 #x6064 #xFFFE)
     (#x2312 #xB6 #xFF32 #x3162 #x3A3 #x252E #x33BE #x24D5 #x24A1 #x3072
      #x30D2 #x431 #xFFFE #xFFFE #xFFFE #xAC8A #xADD1 #xAF80 #xB119 #xB2D0
      #xB460 #xB69D #xB86C #xBA15 #xBC08 #xBD88 #xBFCD #xC18C #xC300 #xC558
      #xC651 #xC783 #xC8E0 #xCAD8 #xCD24 #xCF20 #xD140 #xD32C #xD560 #xD6FD
      #xFFFE #x6746 #x958B #x5E9A #x96C7 #x4E56 #x83CA #x5997 #x55AB #xF93E
      #x5858 #x540C #x51B7 #x7018 #x7A1C #x7F54 #x6C92 #x64B2 #x8919 #x50D5
      #x82AC #x5C04 #x72C0 #x8A75 #x97F6 #x53D4 #x5F0F #x96C1 #xF97D #xF992
      #x502A #x8118 #x53CB #x6E2D #xF9DB #x4EC1 #x6F7A #x9F5F #x5B9A #x773A
      #x99D0 #x73CD #x5879 #x50C9 #x6A1E #x4E03 #x6876 #x530F #x6C57 #x7200
      #x74E0 #x6F62 #x8B4E #xFFFE)
     (#x2202 #x2020 #xFF33 #x3163 #x3A4 #x2531 #x33BF #x24D6 #x24A2 #x3073
      #x30D3 #x432 #xFFFE #xFFFE #xFFFE #xAC8B #xADD3 #xAF84 #xB11B #xB2D2
      #xB461 #xB6A0 #xB86D #xBA38 #xBC09 #xBD89 #xBFD0 #xC18D #xC308 #xC559
      #xC653 #xC784 #xC8E1 #xCAD9 #xCD28 #xCF24 #xD141 #xD330 #xD565 #xD700
      #xFFFE #x67EC #x5580 #x5F91 #x9867 #x5080 #x97A0 #x64D2 #x513A #xF93F
      #x5E62 #x61A7 #x63A0 #x7210 #x7DBE #x8292 #x5922 #x6734 #x8CE0 #x5310
      #x8CC1 #x5DF3 #x76F8 #x8DE3 #x9A37 #x587E #x606F #x978D #x8B93 #x70DF
      #xF9B5 #x8155 #x53F3 #x7232 #x807F #x5203 #x76DE #x52E3 #x5E40 #x7956
      #x7AF9 #x7468 #x6158 #x5C16 #x6E6B #x67D2 #xFA05 #x5486 #x6F22 #x8D6B
      #x7693 #x714C #x9DF8 #xFFFE)
     (#x2207 #x2021 #xFF34 #x3164 #x3A5 #x2532 #x3390 #x24D7 #x24A3 #x3074
      #x30D4 #x433 #xFFFE #xFFFE #xFFFE #xAC8C #xADDC #xAF88 #xB11C #xB2D8
      #xB463 #xB6A4 #xB86F #xBA39 #xBC0B #xBD8A #xBFD4 #xC18E #xC309 #xC55D
      #xC654 #xC785 #xC8E4 #xCAE0 #xCD2C #xCF2C #xD143 #xD338 #xD568 #xD704
      #xFFFE #x687F #x5BA2 #x6176 #x9AD8 #x584A #x97AB #x6611 #xF90B #xF940
      #x6207 #x6771 #x7565 #x76E7 #x83F1 #x832B #x6726 #x6A38 #x8F29 #x535C
      #x96F0 #x5E2B #x7965 #x9078 #x4FD7 #x5919 #x62ED #x9854 #x91C0 #x7136
      #x5208 #x839E #x5B87 #x744B #x620E #x5370 #x5C91 #x540A #x5EAD #x795A
      #x7CA5 #x74A1 #x6159 #x6CBE #x76BA #x6F06 #x75DB #x54FA #x6FA3 #x9769
      #x795C #x749C #x5147 #xFFFE)
     (#x2261 #x2195 #xFF35 #x3165 #x3A6 #x2535 #x3391 #x24D8 #x24A4 #x3075
      #x30D5 #x434 #xFFFE #xFFFE #xFFFE #xAC90 #xADE0 #xAF90 #xB11D #xB2D9
      #xB465 #xB6AB #xB871 #xBA3C #xBC0C #xBD90 #xBFDC #xC190 #xC30C #xC55E
      #xC655 #xC787 #xC8F5 #xCAEC #xCD39 #xCF2D #xD144 #xD339 #xD569 #xD711
      #xFFFE #x6F97 #x5751 #x61AC #x9F13 #x58DE #x9EB4 #x6A8E #xF90C #xF941
      #x649E #x6850 #x4EAE #x8001 #x9675 #x83BD #x8499 #x6CCA #x914D #x5B93
      #xF967 #x5F99 #x7BB1 #x9291 #x5C6C #x5B70 #x690D #x9B9F #x967D #x7159
      #x53E1 #x8C4C #x5BD3 #x7DEF #x701C #xF9ED #x66AB #x5AE1 #x5EF7 #x79DF
      #x4FCA #x755B #x61FA #x6DFB #x79CB #x4FB5 #x7B52 #x5703 #x701A #x4FD4
      #x7CCA #x7687 #x51F6 #xFFFE)
     (#x2252 #x2197 #xFF36 #x3166 #x3A7 #x2536 #x3392 #x24D9 #x24A5 #x3076
      #x30D6 #x435 #xFFFE #xFFFE #xFFFE #xAC94 #xADE4 #xAF91 #xB123 #xB2DB
      #xB46C #xB6AC #xB878 #xBA40 #xBC0D #xBD91 #xBFDF #xC194 #xC30D #xC560
      #xC65C #xC788 #xC8FC #xCAF4 #xCD5C #xCF2F #xD145 #xD33B #xD56B #xD718
      #xFFFE #x764E #xF901 #x64CE #x54ED #x602A #x541B #x7434 #x5A1C #xF942
      #x68E0 #x68DF #x5006 #x8606 #x4FDA #x8F1E #x536F #x73C0 #x966A #x5FA9
      #x4F5B #x601D #x7FD4 #x9425 #x675F #x5BBF #x6B96 #x65A1 #xF97E #xF993
      #x66F3 #x962E #x5C24 #x80C3 #x7D68 #x54BD #x6F5B #x5BC2 #x5F81 #x7A20
      #x5101 #x75B9 #x65AC #x751B #x82BB #x5BE2 #x7D71 #x5E03 #x7F55 #x5CF4
      #x7E1E #x7BC1 #x5308 #xFFFE)
     (#xA7 #x2199 #xFF37 #x3167 #x3A8 #x2539 #x3393 #x24DA #x24A6 #x3077
      #x30D7 #x451 #xFFFE #xFFFE #xFFFE #xAC9C #xADF8 #xAF95 #xB124 #xB2DD
      #xB480 #xB6B1 #xB87C #xBA42 #xBC0F #xBD93 #xBFE1 #xC196 #xC313 #xC561
      #xC65D #xC789 #xC8FD #xCB08 #xCD60 #xCF30 #xD14C #xD33C #xD56D #xD719
      #xFFFE #x770B #x7CB3 #x656C #x659B #x6127 #x7A98 #x7981 #x61E6 #xF943
      #x7576 #x6D1E #x5169 #x865C #x5229 #x9099 #x5893 #x749E #x4F2F #x670D
      #x5F17 #x6368 #x88F3 #x994D #x6D91 #x6DD1 #x6E5C #x8B01 #x990A #x71C3
      #x6C6D #x9811 #x611A #x840E #x878D #x56E0 #x7BB4 #x6458 #x60C5 #x7A95
      #x51C6 #x76E1 #x7AD9 #x77BB #x8429 #x6795 #x901A #x6016 #x7FF0 #x5F26
      #x80E1 #x7C27 #x6D36 #xFFFE)
     (#x203B #x2196 #xFF38 #x3168 #x3A9 #x253A #x3394 #x24DB #x24A7 #x3078
      #x30D8 #x436 #xFFFE #xFFFE #xFFFE #xAC9D #xADF9 #xAF9C #xB125 #xB2E2
      #xB488 #xB6D4 #xB88D #xBA48 #xBC11 #xBD95 #xC03C #xC19C #xC314 #xC564
      #xC660 #xC78A #xC900 #xCB10 #xCD64 #xCF31 #xD14D #xD33D #xD574 #xD71C
      #xFFFE #x78F5 #x7FB9 #x666F #x66F2 #x62D0 #x7FA4 #x79BD #xF90D #x6FC3
      #x7CD6 #x6F7C #x51C9 #x8DEF #x5398 #x57CB #x5999 #x7B94 #x4F70 #x798F
      #x5F7F #x659C #x89F4 #x9BAE #x7C9F #x6F5A #x7184 #x8ECB #x5704 #x71D5
      #x6FCA #x66F0 #x6182 #x8466 #xF9DC #x59FB #x7C2A #x6575 #x633A #x7C97
      #x57C8 #x771E #x8B92 #x7C3D #x8ACF #x6C88 #x5806 #x629B #x9591 #x61F8
      #x82A6 #x8352 #x80F8 #xFFFE)
     (#x2606 #x2198 #xFF39 #x3169 #xFFFE #x253D #x2126 #x24DC #x24A8 #x3079
      #x30D9 #x437 #xFFFE #xFFFE #xFFFE #xAC9F #xADFC #xAFB8 #xB128 #xB2E4
      #xB49D #xB6F0 #xB8A8 #xBA49 #xBC14 #xBD99 #xC051 #xC19D #xC315 #xC568
      #xC66C #xC78E #xC904 #xCB14 #xCD6C #xCF38 #xD150 #xD344 #xD575 #xD720
      #xFFFE #x7A08 #x91B5 #x66BB #x688F #x69D0 #x88D9 #x82A9 #x62CF #xF944
      #x87B3 #x75BC #x6881 #x8F05 #x540F #x59B9 #x5EDF #x7C95 #x5E1B #x8179
      #x62C2 #x65AF #x8A73 #x5368 #x7E8C #x719F #x7BD2 #x95BC #x5FA1 #xF994
      #x730A #x5F80 #x65F4 #x853F #x57A0 #x5BC5 #x8836 #x6EF4 #x653F #x7CDF
      #x5BEF #x778B #x8B96 #x7C64 #x8DA8 #x6D78 #x69CC #x62B1 #x9592 #x665B
      #x846B #x8757 #x9ED1 #xFFFE)
     (#x2605 #x266D #xFF3A #x316A #xFFFE #x253E #x33C0 #x24DD #x24A9 #x307A
      #x30DA #x438 #xFFFE #xFFFE #xFFFE #xACA0 #xADFF #xAFB9 #xB12C #xB2E5
      #xB4A4 #xB6F4 #xB8B0 #xBA4B #xBC15 #xBD9A #xC058 #xC19F #xC318 #xC570
      #xC66F #xC790 #xC905 #xCB18 #xCD6D #xCF54 #xD154 #xD345 #xD578 #xD728
      #xFFFE #x7AFF #x5028 #x66F4 #x7A40 #x9B41 #x8ECD #x887E #x62FF #xF945
      #x9EE8 #x77B3 #x6A11 #x9732 #x550E #x5A92 #x63CF #x7E1B #x67CF #x832F
      #x5D29 #x67F6 #x8C61 #x5C51 #x8B16 #x7421 #x8755 #x5535 #x65BC #x784F
      #x777F #x65FA #x725B #x875F #x6069 #x5F15 #x96DC #x72C4 #x6574 #x7D44
      #x5CFB #x79E6 #x5009 #x8A79 #x8FFD #x741B #x817F #x6355 #x9650 #x6CEB
      #x84BF #x9051 #x6615 #xFFFE)
     (#x25CB #x2669 #xFF3B #x316B #xFFFE #x2540 #x33C1 #x24DE #x24AA #x307B
      #x30DB #x439 #xFFFE #xFFFE #xFFFE #xACA1 #xAE00 #xAFBC #xB134 #xB2E6
      #xB4A8 #xB6F8 #xB8B4 #xBA4D #xBC16 #xBD9C #xC05C #xC1A1 #xC31C #xC571
      #xC671 #xC791 #xC906 #xCB20 #xCD6F #xCF55 #xD15C #xD37C #xD57C #xD729
      #xFFFE #x7C21 #x53BB #x6897 #x8C37 #x5B8F #x90E1 #x887F #xF90E #x81BF
      #x4EE3 #x7AE5 #x7CAE #x9B6F #x5C65 #x5BD0 #x6634 #x818A #x6822 #x8514
      #x670B #x67FB #x8CDE #x6954 #x8D16 #x74B9 #x8B58 #x5CA9 #x6F01 #x786F
      #x7A62 #x6789 #x7397 #x885B #x6147 #x5FCD #x4E08 #xF9FB #x65CC #x7E70
      #x6659 #x7E09 #x5021 #x8AC2 #x9112 #x7827 #x892A #xFA06 #x97D3 #x70AB
      #x864E #x968D #x6B23 #xFFFE)
     (#x25CF #x266A #xFFE6 #x316C #xFFFE #x2541 #x338A #x24DF #x24AB #x307C
      #x30DC #x43A #xFFFE #xFFFE #xFFFE #xACA8 #xAE01 #xAFC0 #xB135 #xB2E8
      #xB4AC #xB700 #xB8B8 #xBA4E #xBC17 #xBDA4 #xC060 #xC1A5 #xC324 #xC573
      #xC678 #xC794 #xC90C #xCB21 #xCD71 #xCF58 #xD15D #xD37D #xD584 #xD72B
      #xFFFE #x809D #x5C45 #x6D87 #x9D60 #x7D18 #x5800 #x895F #xF90F #x8FB2
      #x5788 #x80F4 #x7CB1 #x9DFA #x60A7 #x6627 #x6773 #x8236 #x767D #x8907
      #x68DA #x68AD #x971C #x6CC4 #x901F #x8085 #x8EFE #x5DD6 #x7600 #xF995
      #x82AE #x6C6A #x7440 #x8918 #x6BB7 #x6E6E #x4ED7 #x7684 #x6676 #x8087
      #x6A3D #x7E1D #x5275 #x581E #x914B #x91DD #x9000 #x6CE1 #x5272 #x7384
      #x865F #x9EC3 #x7098 #xFFFE)
     (#x25CE #x266C #xFF3D #x316D #xFFFE #x2543 #x338B #x24E0 #x24AC #x307D
      #x30DD #x43B #xFFFE #xFFFE #xFFFE #xACA9 #xAE08 #xAFC7 #xB137 #xB2EB
      #xB4B5 #xB701 #xB8C0 #xBA53 #xBC18 #xBDB0 #xC068 #xC1A8 #xC325 #xC574
      #xC679 #xC796 #xC90D #xCB41 #xCD78 #xCF5C #xD15F #xD380 #xD585 #xD72D
      #xFFFE #x826E #x5DE8 #x7085 #x56F0 #x80B1 #x5C48 #xF90A #xF910 #x60F1
      #x576E #x8463 #x7CE7 #x9E75 #x674E #x679A #x6E3A #x8584 #x767E #x8986
      #x787C #x6B7B #x585E #x6D29 #x5B6B #x83FD #x98DF #x5EB5 #x79A6 #x7B75
      #x85DD #x738B #x76C2 #x8B02 #x8ABE #xF9EE #x5320 #x7A4D #x6678 #x85FB
      #x6D5A #x81FB #x5531 #x59BE #x919C #x937C #x9839 #x6D66 #x8F44 #x73B9
      #x8774 #x532F #x75D5 #xFFFE)
     (#x25C7 #x327F #xFF3E #x316E #xFFFE #x2544 #x338C #x24E1 #x24AD #x307E
      #x30DE #x43C #xFFFE #xFFFE #xFFFE #xACAA #xAE09 #xAFC8 #xB138 #xB2EC
      #xB4B7 #xB705 #xB8C1 #xBA54 #xBC1B #xBDB8 #xC069 #xC1A9 #xC328 #xC575
      #xC67C #xC797 #xC90F #xCB48 #xCD88 #xCF64 #xD161 #xD384 #xD587 #xD734
      #xFFFE #x8271 #x62D2 #x70F1 #x5764 #x8F5F #x6398 #x9326 #xF911 #xF946
      #x5927 #x9285 #x826F #x788C #x68A8 #x6885 #x732B #x8FEB #x9B44 #x8F39
      #x7E43 #x6C99 #x74BD #x6E2B #x5DFD #x5DE1 #x98FE #x6697 #x8A9E #x7DE3
      #x8602 #x502D #x7950 #x9055 #x9280 #xF9EF #x5834 #x7B1B #x67FE #x86A4
      #x6E96 #x852F #x5A3C #x5E16 #x9310 #x87C4 #x5078 #x75B1 #x51FD #x73FE
      #x8B77 #x56DE #x5403 #xFFFE)
     (#x25C6 #x321C #xFF3F #x316F #xFFFE #x2545 #x33D6 #x24E2 #x24AE #x307F
      #x30DF #x43D #xFFFE #xFFFE #xFFFE #xACAC #xAE0B #xAFC9 #xB139 #xB2ED
      #xB4B9 #xB728 #xB8C3 #xBA55 #xBC1C #xBDD4 #xC090 #xC1AC #xC329 #xC57C
      #xC680 #xC798 #xC911 #xCB49 #xCD94 #xCF65 #xD168 #xD38C #xD588 #xD735
      #xFFFE #x8AEB #x636E #x749F #x5D11 #x4EA4 #x7A9F #x4F0B #xF912 #xF947
      #x5C0D #x515C #x8AD2 #x797F #x6D6C #x6BCF #x7AD7 #x96F9 #x5E61 #x8F3B
      #x9D6C #x6CD7 #x8CFD #x820C #x640D #x5F87 #x4F38 #x764C #x99AD #xF996
      #xF9B6 #x5A03 #x7991 #x97CB #x96B1 #x7D6A #x58BB #x7C4D #x6968 #x8A54
      #x6FEC #x8897 #x5EE0 #x6377 #x9318 #x79E4 #x5957 #x7832 #x542B #x7729
      #x8C6A #x5EFB #x5C79 #xFFFE)
     (#x25A1 #x2116 #xFF40 #x3170 #xFFFE #x2546 #x33C5 #x24E3 #x24AF #x3080
      #x30E0 #x43E #xFFFE #xFFFE #xFFFE #xACAF #xAE0D #xAFCB #xB140 #xB2EE
      #xB4C0 #xB729 #xB8C5 #xBA58 #xBC1D #xBDD5 #xC091 #xC1B0 #xC345 #xC57D
      #xC688 #xC79A #xC918 #xCB4C #xCD95 #xCF67 #xD16C #xD38D #xD589 #xD738
      #xFFFE #x9593 #x64DA #x74A5 #x6606 #x50D1 #x5BAE #x53CA #xF913 #x8166
      #x5CB1 #x6597 #x8F1B #x7DA0 #x7281 #x7164 #x82D7 #x99C1 #x6A0A #x99A5
      #x4E15 #x6E23 #x55C7 #x859B #x84C0 #x5FAA #x4F81 #x83F4 #x9B5A #x7E2F
      #x88D4 #x6B6A #x79B9 #x9B4F #x4E59 #x8335 #x58EF #x7E3E #x6A89 #x8ABF
      #x710C #x8A3A #x5F70 #x7252 #x939A #x7A31 #x59AC #x80DE #x54B8 #x774D
      #x93AC #x5F8A #x7D07 #xFFFE)
     (#x25A0 #x33C7 #xFF41 #x3171 #x3B1 #x2547 #x33AD #x24E4 #x24B0 #x3081
      #x30E1 #x43F #xFFFE #xFFFE #xFFFE #xACB0 #xAE14 #xAFCD #xB141 #xB2EF
      #xB4C4 #xB72C #xB8CC #xBA5C #xBC1E #xBDD8 #xC094 #xC1BD #xC368 #xC580
      #xC689 #xC7A0 #xC92C #xCB50 #xCD98 #xCF69 #xD17C #xD38F #xD590 #xD73C
      #xFFFE #x4E6B #x64E7 #x74CA #x68B1 #x54AC #x5F13 #x6025 #x90A3 #xF948
      #x5E36 #x675C #x91CF #x83C9 #x72F8 #x7F75 #x9328 #x4F34 #x7169 #x9C12
      #x5099 #x7009 #xF96C #x893B #x905C #x6042 #x4FE1 #x95C7 #x9F6C #xF997
      #x8A63 #x77EE #x7D06 #x4E73 #x541F #xF9F0 #x596C #x7FDF #x6B63 #x8D99
      #x756F #x8CD1 #x6134 #x758A #x96DB #x5FEB #x6295 #x812F #x5563 #x7D43
      #x9800 #x6062 #x8A16 #xFFFE)
     (#x25B3 #x2122 #xFF42 #x3172 #x3B2 #x2548 #x33AE #x24E5 #x24B1 #x3082
      #x30E2 #x440 #xFFFE #xFFFE #xFFFE #xACB8 #xAE30 #xAFCE #xB144 #xB2F3
      #xB4C8 #xB72F #xB8D0 #xBA64 #xBC1F #xBDDC #xC098 #xC1C4 #xC369 #xC584
      #xC68B #xC7A1 #xC934 #xCB58 #xCD9C #xCF70 #xD184 #xD390 #xD5A5 #xD744
      #xFFFE #x559D #x6E20 #x75D9 #x68CD #x55AC #x7A79 #x6271 #xF914 #xF949
      #x5F85 #x6793 #x4FB6 #x9304 #x7406 #x8CB7 #x52D9 #x534A #x71D4 #x672C
      #x5315 #x7345 #x7A61 #x8A2D #x98E1 #x65EC #x547B #x58D3 #x5104 #x884D
      #x8B7D #x5916 #x7FBD #x4F91 #x6DEB #x8693 #x5C07 #x837B #x6C40 #x8E81
      #x7AE3 #x8EEB #x655E #x776B #x9A36 #x4ED6 #x900F #x82DE #x558A #x7D62
      #x9865 #x6094 #x6B20 #xFFFE)
     (#x25B2 #x33C2 #xFF43 #x3173 #x3B3 #x2549 #x33AF #x24E6 #x24B2 #x3083
      #x30E3 #x441 #xFFFE #xFFFE #xFFFE #xACB9 #xAE31 #xAFD4 #xB148 #xB2F4
      #xB4D0 #xB730 #xB8D4 #xBA65 #xBC24 #xBDE9 #xC0A0 #xC1C8 #xC36C #xC587
      #xC68D #xC7A3 #xC950 #xCB59 #xCDA4 #xCF71 #xD188 #xD391 #xD5C8 #xD747
      #xFFFE #x66F7 #x70AC #x786C #x6EFE #x5B0C #x7AAE #x6C72 #xF915 #x5C3F
      #x6234 #x75D8 #x5137 #x9E7F #x7483 #x8CE3 #x5DEB #x53CD #x756A #x4E76
      #x532A #x7802 #x7D22 #x8AAA #x7387 #x6812 #x5A20 #x62BC #x61B6 #x8EDF
      #x8C6B #x5D6C #x828B #x5112 #x852D #x8A8D #x5E33 #x8B2B #x6DC0 #x9020
      #x8822 #x8FB0 #x660C #x8ADC #x9C0D #x54A4 #x9B2A #x8461 #x6ABB #x7E23
      #x60D1 #x61F7 #x6B3D #xFFFE)
     (#x25BD #x33D8 #xFF44 #x3174 #x3B4 #x254A #x33DB #x24E7 #x24B3 #x3084
      #x30E4 #x442 #xFFFE #xFFFE #xFFFE #xACBB #xAE34 #xAFDC #xB150 #xB2F5
      #xB4D5 #xB738 #xB8DD #xBA67 #xBC25 #xBDF0 #xC0A1 #xC1CC #xC370 #xC58C
      #xC694 #xC7A4 #xC951 #xCB5D #xCDA5 #xCF74 #xD1A0 #xD398 #xD5C9 #xD749
      #xFFFE #x6E34 #x795B #x78EC #x7428 #x5DA0 #x828E #x7D1A #xF916 #xF94A
      #x64E1 #x7AC7 #x52F5 #x9E93 #xF962 #x9081 #x61AE #x53DB #xF964 #x4FF8
      #x5351 #x793E #x8272 #x96EA #x5B8B #x696F #x5BB8 #x72CE #x6291 #xF998
      #xF9B7 #x5DCD #x85D5 #x516A #x9670 #xF9F1 #x5E84 #x8CCA #x6DE8 #x906D
      #x9021 #x9032 #x6636 #x8CBC #x4E11 #x553E #x615D #x84B2 #x6DB5 #x8237
      #x6216 #x6666 #x6B46 #xFFFE)
     (#x25BC #x2121 #xFF45 #x3175 #x3B5 #xFFFE #x33A9 #x24E8 #x24B4 #x3085
      #x30E5 #x443 #xFFFE #xFFFE #xFFFE #xACBC #xAE37 #xAFE8 #xB151 #xB2F7
      #xB4DC #xB739 #xB8DF #xBA68 #xBC27 #xBDF4 #xC0A3 #xC1D4 #xC372 #xC58D
      #xC695 #xC7A5 #xC954 #xCB64 #xCDA7 #xCF78 #xD1A1 #xD399 #xD5CC #xD750
      #xFFFE #x78A3 #x8DDD #x7ADF #x889E #x5DE7 #x8EAC #x7D66 #xF917 #xF94B
      #x73B3 #x8373 #x5442 #x8AD6 #x75E2 #x9B45 #x61CB #x62CC #x7E41 #x5949
      #x5983 #x7940 #x7272 #x9F67 #x609A #x6A53 #x613C #x9D28 #x6A8D #xF999
      #x92B3 #x7325 #x865E #xF9C7 #x97F3 #x976D #x5F35 #x8D64 #x6E1F #x91E3
      #x9075 #x93AD #x66A2 #x8F12 #x755C #x58AE #x7279 #x888D #x7DD8 #x8852
      #x9177 #x6703 #x5438 #xFFFE)
     (#x2192 #xFFFE #xFF46 #x3176 #x3B6 #xFFFE #x33AA #x24E9 #x24B5 #x3086
      #x30E6 #x444 #xFFFE #xFFFE #xFFFE #xACBD #xAE38 #xAFE9 #xB154 #xB2F8
      #xB4DD #xB73B #xB8E1 #xBA69 #xBC29 #xBDF8 #xC0A5 #xC1D7 #xC378 #xC58F
      #xC698 #xC7A6 #xC958 #xCB78 #xCDA9 #xCF80 #xD1A4 #xD39C #xD5D0 #xD751
      #xFFFE #x7AED #x8E1E #x7AF6 #x9BE4 #x652A #x5026 #x4E98 #xF918 #xF94C
      #x81FA #xF95A #x5EEC #x58DF #x7C6C #x8108 #x620A #x642C #x8543 #x5C01
      #x5A62 #x7960 #x751F #x5261 #x677E #x6B89 #x65B0 #x4EF0 #x81C6 #xF99A
      #xF9B8 #x754F #x8FC2 #x552F #x98EE #x9777 #x638C #x8DE1 #x6E5E #x963B
      #x96CB #x9663 #x69CD #x5EF3 #x795D #x59A5 #x95D6 #x8912 #x8266 #xFA0A
      #x5A5A #x6A9C #x6070 #xFFFE)
     (#x2190 #xFFFE #xFF47 #x3177 #x3B7 #xFFFE #x33AB #x2460 #x2474 #x3087
      #x30E7 #x445 #xFFFE #xFFFE #xFFFE #xACC1 #xAE3A #xAFF0 #xB155 #xB2F9
      #xB4E0 #xB744 #xB8E8 #xBA70 #xBC2D #xBE00 #xC0AC #xC1D8 #xC379 #xC591
      #xC69C #xC7AC #xC960 #xCB79 #xCDB0 #xCF85 #xD1A8 #xD3A0 #xD5D2 #xD754
      #xFFFE #x845B #xF902 #x7D45 #x6C68 #x654E #x5238 #x5162 #x8AFE #xF94D
      #x888B #x8C46 #x616E #x5F04 #x7F79 #x8C8A #x62C7 #x6500 #x85E9 #x5CEF
      #x5E87 #x79C1 #x7525 #x66B9 #x6DDE #x6D35 #x6668 #x592E #x5043 #x925B
      #x9713 #xF9BA #x9047 #x55A9 #x63D6 #xF9F2 #x66B2 #x8E5F #x701E #x96D5
      #x99FF #x9673 #x6EC4 #x6674 #x7AFA #x60F0 #x5761 #x900B #x929C #x8CE2
      #x660F #x6DEE #x6D3D #xFFFE)
     (#x2191 #xFFFE #xFF48 #x3178 #x3B8 #xFFFE #x33AC #x2461 #x2475 #x3088
      #x30E8 #x446 #xFFFE #xFFFE #xFFFE #xACC4 #xAE40 #xAFF1 #xB158 #xB2FA
      #xB4E3 #xB748 #xB8E9 #xBA71 #xBC30 #xBE03 #xC0AD #xC1E0 #xC37C #xC595
      #xC6A4 #xC7AD #xC961 #xCB9C #xCDC4 #xCF8C #xD1B0 #xD3A8 #xD5D8 #xD756
      #xFFFE #x8910 #x907D #x7D93 #xF904 #x6821 #x52F8 #x77DC #xF919 #xF94E
      #x8CB8 #x9017 #x623E #x6727 #x7FB8 #x964C #x64AB #x6591 #x98DC #x5CF0
      #x60B2 #x7BE9 #xF96D #x6BB2 #x8A1F #x6DF3 #x71FC #x600F #x5830 #xF99B
      #x9810 #xF9BB #x90F5 #x5B7A #x6CE3 #xF9F3 #x6756 #x8FEA #x70A1 #x9CE5
      #x8301 #x9707 #x6F32 #x6DF8 #x7B51 #x6253 #x5A46 #x92EA #x9677 #x9249
      #x6DF7 #x6FAE #x7FD5 #xFFFE)
     (#x2193 #xFFFE #xFF49 #x3179 #x3B9 #xFFFE #x33DD #x2462 #x2476 #x3089
      #x30E9 #x447 #xFFFE #xFFFE #xFFFE #xACC8 #xAE41 #xAFF4 #xB15C #xB2FB
      #xB4E4 #xB74C #xB8EC #xBA74 #xBC31 #xBE05 #xC0AF #xC1E4 #xC37D #xC597
      #xC6A5 #xC7B0 #xC963 #xCBB8 #xCDCC #xCFA1 #xD1B1 #xD3A9 #xD5D9 #xD757
      #xFFFE #x874E #x9245 #x8015 #x9AA8 #x6A4B #x5377 #x80AF #xF91A #xF94F
      #x968A #x982D #x65C5 #x7027 #x8389 #x9A40 #x65E0 #x69C3 #x4F10 #x6367
      #x618A #x7D17 #x7B19 #x7E96 #x8AA6 #x73E3 #x7533 #x663B #x5F66 #x9CF6
      #x4E94 #x50E5 #x91EA #x5BA5 #x9091 #x4E00 #x6A1F #x8FF9 #x738E #x65CF
      #x4E2D #x4F84 #x7316 #x807D #x7BC9 #x62D6 #x5DF4 #x98FD #x9E79 #x986F
      #x6E3E #x7070 #x8208 #xFFFE)
     (#x2194 #xFFFE #xFF4A #x317A #x3BA #xFFFE #x33D0 #x2463 #x2477 #x308A
      #x30EA #x448 #xFFFE #xFFFE #xFFFE #xACCC #xAE43 #xAFF8 #xB160 #xB2FF
      #xB4E6 #xB754 #xB8F0 #xBA78 #xBC34 #xBE0C #xC0B0 #xC1E8 #xC384 #xC598
      #xC6A7 #xC7B4 #xC96C #xCBD4 #xCDD0 #xCFA8 #xD1B3 #xD3AB #xD5DB #xD758
      #xFFFE #x97A8 #x92F8 #x803F #x4F9B #x72E1 #x5708 #x4F01 #xF91B #xF950
      #x9EDB #x5C6F #x6ADA #x74CF #x88CF #x9EA5 #x6959 #x6CEE #x7B4F #x68D2
      #x6249 #x7D72 #x5885 #x87FE #x9001 #x76FE #x795E #x6B83 #x7109 #xF99C
      #x4F0D #x51F9 #x9685 #x5E7C #x51DD #x4F5A #x6AA3 #x9069 #x73FD #x7C07
      #x4EF2 #x53F1 #x7621 #x83C1 #x7E2E #x6736 #x628A #x9B91 #x5408 #x5B51
      #x743F #x736A #x50D6 #xFFFE)
     (#x3013 #xFFFE #xFF4B #x317B #x3BB #xFFFE #x33D3 #x2464 #x2478 #x308B
      #x30EB #x449 #xFFFE #xFFFE #xFFFE #xACD5 #xAE45 #xB000 #xB178 #xB300
      #xB4EC #xB755 #xB8F8 #xBA83 #xBC38 #xBE0D #xC0B3 #xC1F0 #xC388 #xC59C
      #xC6A9 #xC7BC #xC970 #xCBE4 #xCDE8 #xCFB0 #xD1B5 #xD3AD #xD5DD #xD759
      #xFFFE #x52D8 #x4E7E #x811B #x516C #x768E #x62F3 #x4F0E #xF91C #xF951
      #x5B85 #x81C0 #x6FFE #x7C60 #x88E1 #x5B5F #x6B66 #x6F58 #x7F70 #x70FD
      #x6279 #x8086 #x58FB #x8D0D #x980C #x77AC #x7D33 #x79E7 #x8A00 #xF99D
      #x4FC9 #x582F #x96E8 #x5E7D #x61C9 #x4F7E #x6B0C #x93D1 #x753A #x8DB3
      #x8846 #x59EA #x7A93 #x8ACB #x84C4 #x6955 #x64AD #x5E45 #x54C8 #x7A74
      #x9B42 #x7E6A #x51DE #xFFFE)
     (#x226A #xFFFE #xFF4C #x317C #x3BC #xFFFE #x33C3 #x2465 #x2479 #x308C
      #x30EC #x44A #xFFFE #xFFFE #xFFFE #xACD7 #xAE46 #xB001 #xB179 #xB301
      #xB4ED #xB760 #xB8F9 #xBA84 #xBC40 #xBE10 #xC0B4 #xC1F1 #xC38C #xC5A0
      #xC6B0 #xC7BD #xC974 #xCBE7 #xCDEC #xCFC4 #xD1BA #xD3B4 #xD5E4 #xD760
      #xFFFE #x574E #x4EF6 #x8396 #x5171 #x77EF #x6372 #x5176 #x6696 #x5AE9
      #x5FB7 #x829A #x792A #x807E #x91CC #x6C13 #x6BCB #x73ED #x95A5 #x71A2
      #x6590 #x820D #x5DBC #x9583 #x5237 #x7B4D #x814E #x9D26 #x8AFA #xF99E
      #x50B2 #x592D #x96E9 #x5EBE #x81BA #x58F9 #x6F3F #x4F43 #x775B #x93C3
      #x91CD #x5AC9 #x8139 #x9751 #x8E59 #x8235 #x64FA #x66B4 #x76D2 #x8840
      #x5FFD #x81BE #x559C #xFFFE)
     (#x226B #xFFFE #xFF4D #x317D #x3BD #xFFFE #x33C9 #x2466 #x247A #x308D
      #x30ED #x44B #xFFFE #xFFFE #xFFFE #xACE0 #xAE4A #xB004 #xB17C #xB304
      #xB4EF #xB764 #xB8FB #xBA85 #xBC41 #xBE14 #xC0B5 #xC1F3 #xC3C0 #xC5A9
      #xC6B1 #xC7BF #xC97C #xCBE9 #xCDF0 #xCFE0 #xD1BC #xD3B8 #xD5E5 #xD761
      #xFFFE #x582A #x5065 #x8B66 #x529F #x7D5E #x6B0A #x5180 #xF91D #x8A25
      #x60B3 #x9041 #x85DC #x5121 #x91D0 #x731B #x7121 #x7554 #x51E1 #x742B
      #x6787 #x838E #x5E8F #x965D #xF970 #x7D14 #x81E3 #x5393 #x5B7C #x6085
      #x5348 #x5996 #x52D6 #x60A0 #x9DF9 #x65E5 #x7246 #x4F7A #x7887 #x5B58
      #x537D #x5E19 #x8259 #x9BD6 #x8E74 #x9640 #x6777 #x66DD #x86E4 #x9801
      #x60DA #x8334 #x566B #xFFFE)
     (#x221A #xFFFE #xFF4E #x317E #x3BE #xFFFE #x33DC #x2467 #x247B #x308E
      #x30EE #x44C #xFFFE #xFFFE #xFFFE #xACE1 #xAE4C #xB00C #xB180 #xB308
      #xB4F1 #xB768 #xB8FD #xBA87 #xBC43 #xBE1C #xC0B6 #xC1FC #xC3D8 #xC5B4
      #xC6B4 #xC7C0 #xC988 #xCC0C #xCDF8 #xCFE1 #xD1C0 #xD3BC #xD5E8 #xD763
      #xFFFE #x5D4C #x5DFE #x8F15 #x5B54 #x7FF9 #x6DC3 #x55DC #x7156 #x677B
      #x5012 #x906F #x8823 #x7028 #x96E2 #x76F2 #x73F7 #x7622 #x5E06 #x7E2B
      #x69A7 #x84D1 #x5EB6 #x651D #x7051 #x8123 #x8398 #x54C0 #x8616 #x6D85
      #x543E #x59DA #x5F67 #x60DF #x4F9D #x6EA2 #xF9FA #x50B3 #x798E #x5C0A
      #x6ADB #x684E #x83D6 #xFA00 #x8EF8 #x99B1 #x6CE2 #x7011 #x95A4 #x5ACC
      #x7B0F #x86D4 #x56CD #xFFFE)
     (#x223D #xFFFE #xFF4F #x317F #x3BF #xFFFE #x33C6 #x2468 #x247C #x308F
      #x30EF #x44D #xFFFE #xFFFE #xFFFE #xACE4 #xAE4D #xB010 #xB182 #xB310
      #xB4F8 #xB770 #xB904 #xBA8C #xBC44 #xBE1D #xC0BC #xC1FD #xC3D9 #xC5B5
      #xC6B8 #xC7C1 #xC989 #xCC0D #xCDF9 #xCFE4 #xD1D8 #xD3C4 #xD5EC #xD765
      #xFFFE #x611F #x5EFA #x9015 #x5DE5 #x81A0 #x7737 #x5668 #xF91E #x7D10
      #x5200 #x920D #x95AD #x7262 #x9BC9 #x76DF #x755D #x76E4 #x68B5 #x84EC
      #x6BD4 #x86C7 #x5F90 #x6D89 #x788E #x821C #x85AA #x57C3 #x4FFA #xF99F
      #x5433 #x5BE5 #x65ED #x6108 #x501A #x9038 #x7350 #x5168 #x7A0B #x5352
      #x696B #x74C6 #x84BC #x5243 #x9010 #x99DD #x6D3E #x7206 #x95D4 #x4FE0
      #x54C4 #x8AA8 #x59EC #xFFFE)
     (#x221D #xFFFE #xFF50 #x3180 #x3C0 #xFFFE #xFFFE #x2469 #x247D #x3090
      #x30F0 #x44E #xFFFE #xFFFE #xFFFE #xACE7 #xAE4E #xB014 #xB188 #xB311
      #xB514 #xB771 #xB918 #xBAA8 #xBC45 #xBE1F #xC0BD #xC200 #xC3DC #xC5B8
      #xC6B9 #xC7C8 #xC98C #xCC10 #xCDFB #xCFE8 #xD1F4 #xD3C5 #xD5F4 #xD769
      #xFFFE #x61BE #x6106 #x93E1 #x6050 #x854E #x53A5 #x573B #xF91F #xF952
      #x5230 #x5F97 #x9A62 #x78CA #x541D #x840C #x7E46 #x76FC #x6C3E #x8702
      #x6BD6 #x88DF #x6055 #x71EE #x9396 #x8340 #x85CE #x5D16 #x513C #x71B1
      #x55DA #xF9BC #x6631 #x6109 #x5100 #x93B0 #x748B #x5178 #x7A7D #x62D9
      #x6C41 #x75BE #x50B5 #x66FF #x6625 #x502C #x722C #xFA07 #x965C #x5354
      #x5F18 #x8CC4 #x5B09 #xFFFE)
     (#x2235 #xFFFE #xFF51 #x3181 #x3C1 #xFFFE #xFFFE #x246A #x247E #x3091
      #x30F1 #x44F #xFFFE #xFFFE #xFFFE #xACE8 #xAE50 #xB01C #xB189 #xB313
      #xB515 #xB773 #xB920 #xBAA9 #xBC49 #xBE44 #xC0BF #xC204 #xC3DF #xC5B9
      #xC6BA #xC7C9 #xC990 #xCC14 #xCDFD #xCFF0 #xD1F8 #xD3C8 #xD5F5 #xD76C
      #xFFFE #x6221 #x6957 #x9803 #x606D #x86DF #x7357 #x57FA #x96E3 #xF953
      #x5716 #x5D9D #x9A6A #x8CC2 #x6F7E #x51AA #x821E #x78D0 #x6C4E #x9022
      #x6BD7 #x8A50 #x6292 #xF96E #x8870 #x84F4 #x8703 #x611B #x56B4 #xF9A0
      #x5862 #xF9BD #x682F #x63C4 #x5B9C #x99B9 #x7AE0 #x524D #x7CBE #x731D
      #x847A #x79E9 #x57F0 #x6D95 #x693F #x5353 #x7436 #x4FF5 #x4EA2 #x593E
      #x6C5E #x5283 #x5E0C #xFFFE)
     (#x222B #xFFFE #xFF52 #x3182 #x3C3 #xFFFE #xFFFE #x246B #x247F #x3092
      #x30F2 #xFFFE #xFFFE #xFFFE #xFFFE #xACEA #xAE54 #xB01D #xB18B #xB314
      #xB518 #xB775 #xB93C #xBAAB #xBC4C #xBE45 #xC0C0 #xC20C #xC3E0 #xC5BB
      #xC6C0 #xC7CC #xC998 #xCC1C #xCE04 #xCFF1 #xD207 #xD3C9 #xD5F7 #xD770
      #xFFFE #x6562 #x8171 #x9838 #x62F1 #x8F03 #x8568 #x57FC #xF920 #xF954
      #x5835 #x6A59 #x9E97 #x8CDA #x71D0 #x8993 #x8302 #x78FB #x6CDB #x92D2
      #x6BD8 #x8A5E #x637F #x57CE #x91D7 #x8563 #x8A0A #x66D6 #x5944 #xF9A1
      #x58BA #x5DA2 #x715C #x6538 #x610F #x4EFB #x7CA7 #x526A #x7D8E #x5027
      #x589E #x7A92 #x5BC0 #x6EEF #x7443 #x5544 #x7834 #x527D #x4F09 #x5CFD
      #x6CD3 #x7372 #x6199 #xFFFE)
     (#x222C #xFFFE #xFF53 #x3183 #x3C4 #xFFFE #xFFFE #x246C #x2480 #x3093
      #x30F3 #xFFFE #xFFFE #xFFFE #xFFFE #xACEC #xAE56 #xB028 #xB18D #xB315
      #xB51B #xB77C #xB93D #xBAAC #xBC4D #xBE48 #xC0C1 #xC20D #xC3E2 #xC5BC
      #xC6C1 #xC7CE #xC999 #xCC1D #xCE08 #xCFF3 #xD209 #xD3D0 #xD5F9 #xD774
      #xFFFE #x67D1 #x8654 #x9A5A #x63A7 #x8F4E #x8E76 #x5914 #x634F #xF955
      #x5857 #x71C8 #x9ECE #x8CF4 #x7498 #x514D #x856A #x792C #x72AF #x9CF3
      #x6CB8 #x8B1D #x654D #x59D3 #x4FEE #x8A62 #x8EAB #x6DAF #x63A9 #x95B1
      #x5967 #x62D7 #x7A36 #x6709 #x61FF #x58EC #x8178 #x5861 #x8247 #x5B97
      #x618E #x81A3 #x5BE8 #x7DE0 #x51FA #x577C #x7F77 #x5F6A #x59EE #x633E
      #x6D2A #x5B96 #x6198 #xFFFE)
     (#x2208 #xFFFE #xFF54 #x3184 #x3C5 #xFFFE #xFFFE #x246D #x2481 #xFFFE
      #x30F4 #xFFFE #xFFFE #xFFFE #xFFFE #xACEF #xAE5C #xB044 #xB192 #xB31C
      #xB51C #xB77D #xB940 #xBAB0 #xBC50 #xBE4C #xC0C5 #xC20F #xC3E8 #xC5BD
      #xC6C3 #xC7D0 #xC99B #xCC21 #xCE0C #xCFF5 #xD210 #xD3D8 #xD600 #xD77C
      #xFFFE #x6A44 #x8E47 #x9BE8 #x653B #x90CA #x95D5 #x5947 #x637A #xF956
      #x5C0E #x767B #x529B #x96F7 #x85FA #x5195 #x8AA3 #x7D46 #x7BC4 #x4E0D
      #xF968 #x8CDC #x6691 #x5BAC #x53D7 #x8AC4 #x8F9B #x788D #x6DF9 #x53AD
      #x5A1B #x6416 #x90C1 #xF9C8 #x64EC #x598A #x81DF #x587C #x8A02 #x5F9E
      #x66FE #x86ED #x5F69 #x8AE6 #x672E #xFA01 #x82AD #x6153 #x5AE6 #x6D79
      #x70D8 #x6A6B #x6231 #xFFFE)
     (#x220B #xFFFE #xFF55 #x3185 #x3C6 #xFFFE #xFFFE #x246E #x2482 #xFFFE
      #x30F5 #xFFFE #xFFFE #xFFFE #xFFFE #xACF0 #xAE5D #xB045 #xB193 #xB354
      #xB524 #xB780 #xB944 #xBAB2 #xBC5D #xBE4E #xC0C8 #xC211 #xC3E9 #xC5BE
      #xC6C5 #xC7D8 #xC99D #xCC22 #xCE14 #xCFFC #xD22C #xD3E1 #xD601 #xD77D
      #xFFFE #x6E1B #x9375 #x4FC2 #x73D9 #x9903 #x673A #x5993 #x5357 #xF957
      #x5C60 #x7B49 #x66C6 #x4E86 #x8EAA #x52C9 #x8CBF #x822C #x8303 #x4ED8
      #x7435 #x8D66 #x66D9 #x6027 #x55FD #x9187 #xF971 #x827E #x5DAA #xF9A2
      #x5BE4 #x6493 #x980A #x67D4 #x6905 #x59D9 #x81E7 #x5960 #x8AEA #x60B0
      #x62EF #x8CEA #x63A1 #x902E #x9EDC #x6258 #x8DDB #x6753 #x5DF7 #x72F9
      #x7D05 #x9404 #x665E #xFFFE)
     (#x2286 #xFFFE #xFF56 #x3186 #x3C7 #xFFFE #xFFFE #xBD #xB9 #xFFFE
      #x30F6 #xFFFE #xFFFE #xFFFE #xFFFE #xACF1 #xAE5F #xB048 #xB194 #xB355
      #xB525 #xB784 #xB94C #xBAB8 #xBC84 #xBE54 #xC0C9 #xC218 #xC3ED #xC5C4
      #xC6CC #xC7DD #xC9C0 #xCC27 #xCE19 #xD000 #xD22D #xD3E3 #xD604 #xD781
      #xFFFE #x7518 #x9A2B #x5553 #x7A7A #x9A55 #x6AC3 #x5BC4 #xF921 #x80FD
      #x5CF6 #x85E4 #x6B77 #x50DA #x96A3 #x68C9 #x9727 #x87E0 #x6CD5 #x4FEF
      #x75FA #x8FAD #x66F8 #x60FA #x56DA #x931E #x8FC5 #x9698 #x696D #xF9A3
      #x609F #x64FE #x4E91 #x67DA #x6BC5 #x6041 #x838A #x5C08 #x8C9E #x616B
      #x70DD #x8DCC #x7826 #x905E #x5145 #xFA02 #x9817 #x6A19 #x6052 #x8105
      #x8679 #x54EE #x66E6 #xFFFE)
     (#x2287 #xFFFE #xFF57 #x3187 #x3C8 #xFFFE #xFFFE #x2153 #xB2 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xACF3 #xAE60 #xB04A #xB198 #xB356
      #xB527 #xB78C #xB94F #xBAB9 #xBC85 #xBE55 #xC0CC #xC219 #xC3F4 #xC5C5
      #xC6CD #xC7E4 #xC9C1 #xCC28 #xCE20 #xD004 #xD230 #xD3EC #xD608 #xD788
      #xFFFE #x75B3 #x4E5E #x583A #x86A3 #x9BAB #x6F70 #x5C90 #x678F #xF958
      #x5D8B #x8B04 #x701D #x5BEE #x9C57 #x6C94 #x9D61 #x8FD4 #x743A #x5085
      #x7812 #x90AA #x6816 #x6210 #x5782 #x9806 #x5931 #x9744 #x5186 #xF9A4
      #xF9B9 #xF9BE #xF9C5 #xF9C9 #x7591 #xF9F4 #x846C #x5C55 #x912D #x68D5
      #x7511 #x8FED #x7DB5 #x9AD4 #x5FE0 #x64E2 #x5224 #x6F02 #x6297 #x8107
      #x8A0C #x5686 #x7199 #xFFFE)
     (#x2282 #xFFFE #xFF58 #x3188 #x3C9 #xFFFE #xFFFE #x2154 #xB3 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xACF5 #xAE61 #xB04C #xB19C #xB358
      #xB528 #xB78D #xB951 #xBABB #xBC88 #xBE57 #xC0D0 #xC21C #xC3F5 #xC5C6
      #xC6D0 #xC7E8 #xC9C4 #xCC29 #xCE21 #xD011 #xD234 #xD3ED #xD610 #xD789
      #xFFFE #x76E3 #x5091 #x5951 #x8CA2 #x4E18 #x8A6D #x5D0E #x6960 #xF959
      #x5EA6 #x9127 #x792B #x5ED6 #x9E9F #x7704 #x58A8 #x9812 #x50FB #x5256
      #x7891 #x98FC #x68F2 #x661F #x58FD #x99B4 #x5BA4 #x5384 #x4E88 #x67D3
      #x61CA #x66DC #x6A52 #x6961 #x77E3 #xF9F5 #x8523 #x5EDB #x914A #x6DD9
      #x75C7 #x659F #x83DC #x521D #x6C96 #x666B #x5742 #x74E2 #x676D #x83A2
      #x9D3B #x5B5D #x71B9 #xFFFE)
     (#x2283 #xFFFE #xFF59 #x3189 #xFFFE #xFFFE #xFFFE #xBC #x2074 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xACF6 #xAE65 #xB04E #xB1A8 #xB35B
      #xB529 #xB78F #xB958 #xBABD #xBC8B #xBE59 #xC0D8 #xC21F #xC3F8 #xC5C7
      #xC6D4 #xC7EC #xC9C7 #xCC2C #xCE24 #xD018 #xD23C #xD3F0 #xD611 #xD78C
      #xFFFE #x77B0 #x6770 #x5B63 #x978F #x4E45 #x8ECC #x5DF1 #x6E73 #x5C3C
      #x5F92 #x9A30 #x8F62 #x6599 #x6797 #x7720 #x9ED8 #x98EF #x5288 #x526F
      #x79D5 #x99DF #x7280 #x665F #x5AC2 #x620C #x5BE6 #x627C #x4F59 #xF9A5
      #x6556 #xF9BF #x6B9E #x6962 #x7FA9 #x7A14 #x8594 #x609B #x91D8 #x742E
      #x7E52 #x6715 #x8521 #x527F #x87F2 #x67DD #x677F #x7968 #x6841 #x92CF
      #x5316 #x6548 #x71BA #xFFFE)
     (#x222A #xFFFE #xFF5A #x318A #xFFFE #xFFFE #xFFFE #xBE #x207F #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xACFC #xAE68 #xB053 #xB1CC #xB35C
      #xB52A #xB790 #xB959 #xBAC4 #xBC8C #xBE5A #xC0D9 #xC220 #xC408 #xC5C8
      #xC6DC #xC800 #xC9C8 #xCC2E #xCE28 #xD02D #xD23D #xD3F4 #xD613 #xD790
      #xFFFE #x7D3A #x6840 #x5C46 #x4E32 #x4E5D #x994B #x5E7E #xF922 #x6CE5
      #x60BC #x5587 #x9742 #x71CE #x6DCB #x7DBF #x5011 #x52C3 #x58C1 #x5426
      #x79D8 #x9E9D #x745E #x7329 #x5B88 #x8853 #x6089 #x6396 #xF97F #x708E
      #x65FF #x6A48 #x6F90 #x6CB9 #x8264 #xF9F6 #x85CF #x6230 #x9266 #x7A2E
      #x84B8 #xF9FD #x91C7 #x54E8 #x885D #x6FC1 #x7248 #x8868 #x6C86 #x9830
      #x548C #x6585 #x72A7 #xFFFE)
     (#x2229 #xFFFE #xFF5B #x318B #xFFFE #xFFFE #xFFFE #x215B #x2081 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xACFD #xAE69 #xB054 #xB1D0 #xB35E
      #xB530 #xB791 #xB95C #xBAC8 #xBC8E #xBE5B #xC0DB #xC228 #xC410 #xC5C9
      #xC6DD #xC801 #xC9CA #xCC30 #xCE30 #xD034 #xD23F #xD3FC #xD614 #xD798
      #xFFFE #x90AF #x5109 #x60B8 #x5BE1 #x4EC7 #xF906 #x5FCC #x7537 #x533F
      #x6311 #x61F6 #x6190 #x7642 #x7433 #x7DEC #x520E #x62D4 #x64D8 #x5490
      #x7C83 #x524A #x7B6E #x73F9 #x5CAB #x8FF0 #x5BE9 #x6DB2 #xF980 #x7130
      #x6664 #xF9C0 #x7189 #x6D27 #x858F #x834F #x88DD #x6813 #x92CC #x7D42
      #x8B49 #x57F7 #x91F5 #x6194 #x8877 #x6FEF #x74E3 #x8C79 #x6E2F #x4EA8
      #x5B05 #x66C9 #x79A7 #xFFFE)
     (#x2227 #xFFFE #xFF5C #x318C #xFFFE #xFFFE #xFFFE #x215C #x2082 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xAD00 #xAE6C #xB055 #xB1D4 #xB35F
      #xB531 #xB792 #xB960 #xBAD8 #xBC94 #xBE60 #xC0DC #xC229 #xC424 #xC5CA
      #xC6E0 #xC804 #xC9D0 #xCC38 #xCE31 #xD035 #xD241 #xD3FD #xD615 #xD799
      #xFFFE #x9451 #x528D #x6212 #x6208 #x4FF1 #x6677 #x6280 #xF923 #x6EBA
      #x6389 #xF95B #x6200 #x77AD #x81E8 #x9762 #x543B #x64A5 #x6A97 #x57E0
      #x7DCB #xF969 #x7D6E #x76DB #x5CC0 #x9265 #x5C0B #x7E0A #xF981 #x7430
      #x68A7 #x71FF #x8018 #xF9CA #x87FB #x8CC3 #x8D13 #x6BBF #x9320 #x7D9C
      #x8D08 #x6F57 #x518A #x6284 #x60B4 #x7422 #x8CA9 #x98C7 #x7F38 #x5144
      #x6A3A #x689F #x7A00 #xFFFE)
     (#x2228 #xFFFE #xFF5D #x318D #xFFFE #xFFFE #xFFFE #x215D #x2083 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xAD04 #xAE70 #xB057 #xB1DC #xB364
      #xB534 #xB796 #xB968 #xBAD9 #xBC95 #xBE61 #xC0DD #xC22B #xC42C #xC5CC
      #xC6E1 #xC808 #xC9D1 #xCC39 #xCE33 #xD038 #xD248 #xD3FF #xD61C #xD79B
      #xFFFE #x9452 #x5292 #x6842 #x679C #x5177 #x6B78 #x65D7 #xF924 #x591A
      #x6417 #x7669 #x6523 #x804A #x9716 #x9EB5 #x554F #x6E24 #x74A7 #x592B
      #x7FE1 #x6714 #x7DD6 #x7701 #x5E25 #x5D07 #x5FC3 #x814B #x5982 #x8276
      #x6C5A #x7464 #x82B8 #x6E38 #x8863 #x5165 #x91AC #x6C08 #x9706 #x7E31
      #x4E4B #x7DDD #x67F5 #x62DB #x81B5 #x7438 #x8FA6 #x98C4 #x809B #x5211
      #x706B #x6D8D #x7FB2 #xFFFE)
     (#xFFE2 #xFFFE #xFFE3 #x318E #xFFFE #xFFFE #xFFFE #x215E #x2084 #xFFFE
      #xFFFE #xFFFE #xFFFE #xFFFE #xFFFE #xAD06 #xAE78 #xB059 #xB1DD #xB365
      #xB538 #xB797 #xB969 #xBAFC #xBC97 #xBE64 #xC0E4 #xC22D #xC430 #xC5CE
      #xC6E8 #xC80A #xC9D3 #xCC3B #xCE35 #xD03C #xD25C #xD401 #xD620 #xD79D
      #xFFFE #x9F95 #x6AA2 #x68B0 #x74DC #x52FE #x8CB4 #x65E3 #xF925 #x8336
      #x6843 #x7F85 #x6F23 #x84FC #x782C #x6EC5 #x6587 #x6F51 #x7656 #x5A66
      #x80A5 #xF96A #x7F72 #x7B6C #x6101 #x5D27 #x6C81 #x984D #xF982 #x82D2
      #x6FB3 #xF9C1 #x8553 #xF9CB #x8ABC #x5344 #x9577 #x6FB1 #x9756 #x816B
      #x53EA #x8F2F #x7B56 #x68A2 #x8403 #x8A17 #x9211 #x9A43 #x822A #x578B
      #x7575 #x6DC6 #x8A70 #xFFFE))))

(define-external-format :euc-kr (:min 1 :max 2 :documentation
"EUC-KR is an variable-length character encoding generally intended for
Korean Hangul.

By default, illegal inputs are replaced by the Unicode replacement
character and illegal outputs are replaced by a question mark.")
  ((table +euc-kr+ :type (simple-array (unsigned-byte 16) (94 94)))
   (itable (invert-table table) :type lisp::ntrie16))

  (octets-to-code (state input unput error c c1 c2 code)
    `(let ((,c ,input))
       (cond ((null ,c) (values nil 0))
	     ((<= ,c #x7f) (values ,c 1))
	     ((<= #xa1 ,c #xfd)
	      ;; Remember first octet in case we bail out reading the
	      ;; second octet (for octets-to-string).
	      (setf ,state ,c)
	      (let ((,c2 ,input))
		(cond ((<= #xa1 ,c2 #xfe)
		       ;; Read the second octet, so clear the state
		       (setf ,state nil)
		       (values (aref ,table (- ,c2 #xa1) (- ,c #xa1)) 2))
		      (t
		       (values
			(if ,error
			    (funcall ,error "Invalid second octet: #x~X 2" ,c2 1)
			    +replacement-character-code+)
			2)))))
	     (t
	      (values
	       (if ,error
		   (funcall ,error "Invalid first octet: #x~X 3" ,1 1)
		   +replacement-character-code+)
	       1)))))
  (code-to-octets (code state output error present c1 c2)
    `(if (<= ,code #x7f)
	 (,output ,code)
	 (let ((,present (get-inverse ,itable ,code)))
	   (cond (,present
		  (let* ((,c1 (ldb (byte 8 8) ,present))
			 (,c2 (ldb (byte 8 0) ,present)))
		    (,output (+ ,c1 #xa0))
		    (,output (+ ,c2 #xa0))))
		 (t
		  (if ,error
		      (funcall ,error "Cannot output codepoint #x~X to EUC-KR format." ,code)
		      (,output #X3f)))))))
  ()
  ()
  (octet-count (code state error present)
    `(if (<= ,code #x7f)
	 1
	 (let ((,present (get-inverse ,itable ,code)))
	   (cond (,present
		  2)
		 (t
		  (if ,error
		      (funcall ,error "Cannot output codepoint #x~X to EUC-KR format." ,code)
		      1)))))))
